package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.ExtendPropertyValueModel;
import com.bizvane.members.facade.vo.ExtendPropertyValueVO;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;
import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/13.
 */
public interface ExtendPropertyValueService {
    /**
     * 根据会员Code查询扩展属性列表
     * @param memberCode
     * @return
     * @throws MemberException
     */
    public ResponseData<List<ExtendPropertyValueVO>> findExtendPropertyValueListByMemberCode(Long brandId, String memberCode)throws MemberException;

    /**
     * 根据会员code修改会员扩展属性
     * @param list
     * @param map
     * @return
     */
    ResponseData updateExtendPropertyValueByMemberCode(List<ExtendPropertyValueModel> list, Map map,boolean writeToOffline);
}
