package com.bizvane.members.facade.enums;

public enum OrderFromEnum {

    OFFLINE(1, "线下零售单"),

    CLOUD(3, "云仓订单"),

    MALL(2, "微商城");

    private Integer code;

    private String msg;

    OrderFromEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (CardStatusEnum type : CardStatusEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }

}
