package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/14.
 * 等级流水
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_level_record")
public class LevelRecordModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = -1808675679995716409L;

    @Id
    @ApiModelProperty(value = "等级流水id", name = "levelTraceId")
    private Long levelTraceId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "公众号id", name = "publicId")
    private Long publicId;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "原等级id", name = "originLevelId")
    private Long originLevelId;

    @ApiModelProperty(value = "原等级", name = "originLevel")
    private String originLevelName;

    @ApiModelProperty(value = "当前等级id", name = "currentLevelId")
    private Long currentLevelId;

    @ApiModelProperty(value = "当前等级", name = "currentLevel")
    private String currentLevelName;
    
    @ApiModelProperty(value = "流水条件", name = "conditions")
    private String conditions;
}
