package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: houkai
 * @Date: 2018/7/17 19:26
 * @Description:会员分组实体
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_group_def")
public class MbrGroupModel extends BaseModel implements Serializable {


    private static final long serialVersionUID = 7380602815874029259L;

    @Id
    @ApiModelProperty(value = "分组id", name = "mbrGroupDefId", example = "分组id")
    private Long mbrGroupDefId;

    @ApiModelProperty(value = "归属企业", name = "sysCompanyId", example = "归属企业")
    private Long sysCompanyId;

    @ApiModelProperty(value = "归属品牌:0=表示系统默认,归属所有企业", name = "brandId", example = "归属品牌:0=表示系统默认,归属所有企业")
    private Long brandId;

    @ApiModelProperty(value = "分组类型", name = "groupId", example = "分组类型")
    private Long groupId;

    @ApiModelProperty(value = "分组code", name = "code", example = "分组code")
    private String code;

    @ApiModelProperty(value = "分组名称", name = "name", example = "分组名称")
    private String name;

    @ApiModelProperty(value = "条件类型: 0=基本条件; 1=高级条件", name = "conditionType", example = "条件类型: 0=基本条件; 1=高级条件")
    private Integer conditionType;

    @ApiModelProperty(value = "分组条件", name = "conditions", example = "分组条件")
    private String conditions;

    @ApiModelProperty(value = "运营建议", name = "runningAdvice", example = "运营建议")
    private String runningAdvice;

    @ApiModelProperty(value = "分组指标:1=人群总数;2=近30天累计消费;3=近30天消费占比;注:多选以逗号分隔", name = "groupIndicators", example = "分组指标:1=人群总数;2=近30天累计消费;3=近30天消费占比;注:多选以逗号分隔")
    private String groupIndicators;

    @ApiModelProperty(value = "定向运营:1=发送优惠券;2=送积分;3=群发短信;4=群发微信模板;注:多选,以逗号分隔", name = "directionalOperation", example = "定向运营:1=发送优惠券;2=送积分;3=群发短信;4=群发微信模板;注:多选,以逗号分隔")
    private String directionalOperation;

    @ApiModelProperty(value = "分组分析:1=地域分析;2=年龄分布;3=等级分布;4=渠道偏好等注:多选,以逗号分隔", name = "groupAnalyze", example = "分组分析:1=地域分析;2=年龄分布;3=等级分布;4=渠道偏好等;注:多选,以逗号分隔")
    private String groupAnalyze;

    @ApiModelProperty(value = "人群总数", name = "crowdNumberTotal", example = "人群总数")
    private Integer crowdNumberTotal;

    @ApiModelProperty(value = "最近30天消费金额（元）", name = "recentlyConsumeAmount", example = "最近30天消费金额（元）")
    private BigDecimal recentlyConsumeAmount;

    @ApiModelProperty(value = "最近30天消费占比", name = "recentlyCounsumeRate", example = "最近30天消费占比")
    private Integer recentlyCounsumeRate;

    @ApiModelProperty(value = "分组状态:1=启用;0=禁用;", name = "status", example = "分组状态:1=启用;0=禁用")
    private Integer status;
    
    @ApiModelProperty(value = "所属分组类型名;", name = "groupTypeName", example = "所属分组类型名")
    private String groupTypeName;

    @ApiModelProperty(value = "运营次数;", name = "operateCount", example = "运营次数")
    private Integer operateCount;

    @ApiModelProperty(value = "生命周期max;", name = "lifecycleMax", example = "生命周期max")
    private Integer lifecycleMax;

    @ApiModelProperty(value = "生命周期min;", name = "lifecycleMin", example = "生命周期min")
    private Integer lifecycleMin;

}
