package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.es.vo.SearchTimeRangRequest;
import com.bizvane.members.facade.models.MemberInfoModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/20.
 */
@Data
public class MemberInfoApiModel extends MemberInfoModel{

    private Integer pageNumber;

    private Integer pageSize;

    @ApiModelProperty(value = "会员范围:1微信会员，2全部会员", name = "memberScope")
    private String memberScope;

    @ApiModelProperty(name = "wxMembers", value = "1微信会员，2不是微信会员")
    private Integer wxMembers;

    @ApiModelProperty(value = "生日时间线", name = "birthdayLine")
    private Integer birthdayLine;

    @ApiModelProperty(value = "注册时间线", name = "openCardTimeLine")
    private Integer openCardTimeLine;
    
    @ApiModelProperty(value = "宝宝生日时间线",name = "babyBirthdayLine")
    private Integer babyBirthdayLine;

    @ApiModelProperty(value = "等级ID集合", name = "levelID")
    private List<Long> levelID;

    @ApiModelProperty(value = "开卡开始时间", name = "openCardDateFrom")
    private String openCardDateFrom;

    @ApiModelProperty(value = "开卡结束时间", name = "openCardDateTo")
    private String openCardDateTo;
}
