package com.bizvane.members.facade.vo.qywx;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("删除自定义标签")
public class DeleteCustomizeLabelRequestVO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  
  @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
  @NotNull 
  private Long brandId;
  
  @ApiModelProperty(value = "标签id", name = "mbrLabelDefId", required = true)
  @NotNull 
  private Long mbrLabelDefId;
  
  @ApiModelProperty(value = "创建人id", name = "createUserId", required = true)
  @NotNull 
  private Long createUserId;

  @ApiModelProperty(value = "创建人名字", name = "userName", required = false)
  private String userName;

  public Long getBrandId() {
    return brandId;
  }

  public void setBrandId(Long brandId) {
    this.brandId = brandId;
  }

  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  public Long getMbrLabelDefId() {
    return mbrLabelDefId;
  }

  public void setMbrLabelDefId(Long mbrLabelDefId) {
    this.mbrLabelDefId = mbrLabelDefId;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }
}
