package com.bizvane.members.facade.service.card.request;

import lombok.*;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author dingShiChen
 * @since 2019/10/25
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class IntegralChangeOtherBrandVO {

	/*
		品牌id
	 */
	@NotNull
	private Long sysBrandId;

	/*
		会员线下id
	 */
	@NotEmpty
	private String erpId;

	/*
		变更单据
	 */
	@NotEmpty
	private String changeBills;

	/*
		积分来源:1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
	 */
	@NotEmpty
	private String source;

	/*
		调整积分正负值
	 */
	@NotNull
	private Integer changeIntegral;

	/*
		线下流水id
	 */
	@NotEmpty
	private String offlineIntegralId;

	/*
		线下门店code
	 */
	@NotEmpty
	private String storeCode;


	/*
		积分调整备注
	 */
	private String changeRemark;
}
