package com.bizvane.members.facade.service.api361;

import com.bizvane.members.facade.service.card.request.IntegralChange361ApiRequestModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeOtherBrandVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * <p>
 * 361积分调整接口
 * </p>
 * @author dingShiChen
 * @since 2019/10/17
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface IntegralChange361ApiService {
    /**
     * 积分变动操作
     * @param vo
     * @return
     */
    @PostMapping("/api/integral361/integralChangeOperate")
    ResponseData<String> integralChangeOperateOffline(@RequestBody IntegralChange361ApiRequestModel vo);

    /**
     * 361积分调整，另一个品牌的线上数据补偿，提供给连接器回调
     * @param vo
     * @return
     */
    @PostMapping("/api/integral361/integralChangeOtherBrand")
    ResponseData integralChangeOtherBrand(@RequestBody @Valid IntegralChangeOtherBrandVO vo);
}
