package com.bizvane.members.facade.enums;

/**
 * 阿里智慧门店返回码枚举类
 *
 * 参考 https://istore.tmall.com/doc.htm?docId=109380&docType=1
 */
public enum TMallBindCodeEnum {

    SUC("SUC","可绑定"),
    E01("E01","会员不存在"),
    E02("E02","会员已被绑定"),
    E04("E04","会员不存在，可注册"),
    E05("E05","统繁忙或异常，可重试 其他原因可传F01，F02等， 系统统一识别为会员不存在");


    private String code;
    private String mes;

    TMallBindCodeEnum(String code, String mes) {
        this.code = code;
        this.mes = mes;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMes() {
        return mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }
}
