package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberLabelModel;
import com.bizvane.members.facade.models.QueryCustomizeLabelListRequestVO;
import com.bizvane.members.facade.models.excel.LabelExcelModel;
import com.bizvane.members.facade.models.excel.LabelExcelPO;
import com.bizvane.members.facade.models.po.MbrLabelDefPO;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import javax.validation.Valid;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * @author houkai
 */
public interface MemberLabelService {
    /**
     * 添加标签(批量)
     *
     * @param memberLabelModel
     * @return
     * @throws MemberException
     */
    ResponseData addLabels(MemberLabelModel memberLabelModel) throws MemberException;

    /**
     * 查询标签列表
     *
     * @param paraMap
     * @param pageVo
     * @return
     */
    PageInfo<MemberLabelModel> queryLabelList(MemberLabelModel memberLabelModel, PageVo pageVo);

    /**
     * 查询标签详情
     *
     * @param labelId
     * @return
     */
    MemberLabelModel queryLabelInfo(long labelId);

    /**
     * 根据id删除标签
     *
     * @param memberLabelModel
     * @return
     * @throws MemberException
     */
    ResponseData updateLabelValid(MemberLabelModel memberLabelModel) throws MemberException;

    /**
     * 添加标签计数
     *
     * @param labelId
     * @return
     * @throws MemberException
     */
    ResponseData addCount(long labelId) throws MemberException;

    /**
     * 根据品牌查询标签分页列表
     *
     * @param brandId
     * @param pageVo
     * @return
     */
    ResponseData<PageInfo<MemberLabelModel>> queryLabelsByBrandId(long brandId, PageVo pageVo);

    /**
     * 标签导出查询
     *
     * @param memberLabelModel
     * @return
     */
    List<LabelExcelModel> queryLabels(MemberLabelModel memberLabelModel);

    /**
     * 添加会员标签(单个)
     *
     * @param memberLabelModel
     * @return
     */
    ResponseData addLabel(MemberLabelModel memberLabelModel);

    /**
     * 导入标签
     *
     * @param url
     * @param currentUser
     * @return
     */
    ResponseData importLabelExcel(String url, SysAccountPO currentUser);

    /**
     * 导出excel任务添加
     *
     * @param memberLabelModel
     * @return
     */
    ResponseData exportToExcel(MemberLabelModel memberLabelModel,SysAccountPO currentUser);
    

    /**
     * 查询自定义标签
     * @param requestVO
     * @return
     */
    ResponseData<PageInfo<MbrLabelDefPO>> queryCustomizeLabelList(PageVo pageVo, QueryCustomizeLabelListRequestVO requestVO);
    
    
    ResponseData<String> exportCustomizeLabelList(QueryCustomizeLabelListRequestVO requestVO,Optional<SysAccountPO> optional);


    ResponseData exportNewToExcel(MemberLabelModel memberLabelModel,SysAccountPO currentUser);

     void addExcelLabel(LabelExcelPO labelExcelPO, SysAccountPO currentUser);


    void addNewExcelLabel(Set<LabelExcelPO> labelExcelPOS, SysAccountPO currentUser);


    void addNewLabel(MemberLabelModel memberLabelModel);

    void deleteLabelForMembers(Long labelId,Long sysAccountId,String name);
}
