package com.bizvane.members.facade.service.api361;

import com.bizvane.members.facade.service.card.request.IntegralChange361ApiRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>
 * 361积分调整接口
 * </p>
 * @author dingShiChen
 * @since 2019/10/17
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface IntegralChange361ApiService {
    /**
     * 积分变动操作
     * @param vo
     * @return
     */
    @PostMapping("/api/integral361/integralChangeOperate")
    IntegralChangeResponseModel integralChangeOperate(@RequestBody IntegralChange361ApiRequestModel vo);

    /**
     * 纯线上积分变动
     * @param vo
     * @return
     */
    @PostMapping("/api/integral361/integralChangeOperateOnline")
    IntegralChangeResponseModel integralChangeOperateOnline(@RequestBody IntegralChange361ApiRequestModel vo);
}
