package com.bizvane.members.facade.models;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 更新会员资料接口入参model
 * </p>
 * @author dingShiChen
 * @since 2019/10/15
 */
@Data
public class MemberInfoUpdateRequestVO {

	/*
		企业id
	 */
	@NotNull
	private Long sysCompanyId;

	/*
		品牌id
	 */
	@NotNull
	private Long sysBrandId;

	/*
		会员原始手机号
	 */
	@NotEmpty
	private String phone;

	/*
		会员姓名
	 */
	private String newName;

	/*
		会员手机号
	 */
	private String newPhone;

	/*
		会员性别
	 */
	private String newSex;

	/*
		省
	 */
	private String newProvince;

	/*
		市
	 */
	private String newCity;

	/*
		区
	 */
	private String newCounty;

	/*
		会员详细地址
	 */
	private String newAddress;

	/*
		备注
	 */
	private String newRemark;

	/*
		会员邮箱
	 */
	private String newEmail;

	/*
		会员身份证号
	 */
	private String newIdCard;

	/*
		会员生日 格式：yyyy-MM-dd
	 */
	private Date newBirthday;

	/*
		等级code
	 */
	private String newLevelCode;

	/*
		亲属关系
	 */
	private List<UpdateMemberRelativeRequestVO> relations;
}
