package com.bizvane.members.facade.models.excel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashSet;
import java.util.Set;

/**
 * @Author: houkai
 * @Date: 2018/8/29 14:56
 * @Description:标签导出
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LabelExcelPO {

    @ApiModelProperty(value = "标签分组", name = "labelTypeName", example = "标签分组")
    private String labelTypeName;

    @ApiModelProperty(value = "标签名称", name = "labelName", example = "标签名称")
    private String labelName;

    @ApiModelProperty(value = "标签说明", name = "remark", example = "标签说明")
    private String remark;


    /**
     * 如果对象类型是LabelExcelPO,先比较hashcode，一致的场合再比较每个属性的值
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof LabelExcelPO) {
            LabelExcelPO po = (LabelExcelPO) obj;

            // 比较每个属性的值 一致时才返回true
            if (po.labelName.equals(this.labelName)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 重写hashcode 方法，返回的hashCode不一样才再去比较每个属性的值
     */
    @Override
    public int hashCode() {
        return labelName.hashCode();
    }

    public static void main(String[] args) {
        Set<LabelExcelPO> set = new HashSet<>();
        LabelExcelPO p1 = new LabelExcelPO("1", "1", "kdk");
        LabelExcelPO p2 = new LabelExcelPO("1", "1", "88");
        LabelExcelPO p3 = new LabelExcelPO("2", "1", "kdk");
        set.add(p1);
        set.add(p2);
        set.add(p3);
        for (LabelExcelPO po : set) {
            System.out.println(po.toString());
        }
    }

}
