package com.bizvane.members.facade.models;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Lijc
 * @date on 2019/9/20 10:51
 */
@Data
public class SkuSalesDetailRequestVo implements Serializable {

    /**
     * 调用商家编号
     * */
    @NotNull
    private String businessNum;
    @NotNull
    private String apiKey;

    /**
     * 查询企业编号
     */
    @NotNull
    private String corpId;
    /**
     * 品牌ID
     */
    @NotNull
    private String brandId;
    /**
     * 店铺ID
     */
    @NotNull
    private String storeId;
    /**
     * 导购ID  若维度选择导购，则导购ID必输
     */
    private String empId;
    /**
     * 维度 0-导购
     *      1-店铺
     */
    @NotNull
    private String dimension;
    /**
     * 起始时间  格式为：yyyy-MM-dd HH:mm:ss
     */
    @NotNull
    private String startDate;
    /**
     * 截止时间  格式为：yyyy-MM-dd HH:mm:ss
     */
    @NotNull
    private String endDate;
}
