package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 会员积分转赠记录
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_integral_transfer")
public class MbrIntegralTransferModel extends BaseModel{

    private static final long serialVersionUID = -68361859256502457L;

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    @ApiModelProperty(value = "主键id", name = "mbrIntegralTransferId", example = "主键id")
    private Long mbrIntegralTransferId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "归属品牌", name = "brandId", example = "归属品牌")
    private Long brandId;

    @ApiModelProperty(value = "会员积分转赠流水号", name = "integralTransferCode", example = "会员积分转赠流水号")
    private String integralTransferCode;

    @ApiModelProperty(value = "转赠方会员code", name = "transferMemberCode", example = "转赠方会员code")
    private String transferMemberCode;

    @ApiModelProperty(value = "转赠方转赠积分数", name = "transferIntegral", example = "转赠方转赠积分数")
    private Long transferIntegral;

    @ApiModelProperty(value = "转赠方转赠积分扣除时间", name = "transferIntegralDate", example = "转赠方转赠积分扣除时间")
    private Date transferIntegralDate;

    @ApiModelProperty(value = "受赠方会员code", name = "recipientMemberCode", example = "转赠方会员code")
    private String recipientMemberCode;

    @ApiModelProperty(value = "受赠方领取积分数", name = "recipientIntegral", example = "转赠方会员code")
    private Long recipientIntegral;

    @ApiModelProperty(value = "受赠积分领取时间", name = "recipientIntegralDate", example = "转赠方会员code")
    private Date recipientIntegralDate;

    @ApiModelProperty(value = "积分领取有效期（精确到小时）", name = "integralRecipientValidDate", example = "积分领取有效期（精确到小时）")
    private Date integralRecipientValidDate;
}
