package com.bizvane.members.facade.enums;

import org.springframework.util.Assert;

import java.util.Arrays;
import java.util.Objects;

public enum LabelTypeEnum {
    /**
     * es 筛选类型
     */
    SEARCH_BY_NORMAL(1, "普通筛选"),
    /**
     * es 筛选类型
     */
    SEARCH_BY_BRAND_LABEL(2,"品牌官方"),
    /**
     * es 筛选类型
     */
    SEARCH_BY_QA_LABEL(3,"精准营销");
    private Integer code;

    private String msg;

    LabelTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static LabelTypeEnum formByIndex(Integer code) {
        LabelTypeEnum labelType = Arrays.stream(LabelTypeEnum.values()).filter(p->p.getCode().equals(code))
                .findFirst().orElse(null);
        Assert.isTrue(Objects.nonNull(labelType), "标签筛选类型labelType非法！");
        return labelType;
    }

    public static LabelTypeEnum formByIndexOfNull(Integer code) {
        LabelTypeEnum labelType = Arrays.stream(LabelTypeEnum.values()).filter(p->p.getCode().equals(code))
                .findFirst().orElse(null);
        return labelType;
    }
}
