package com.bizvane.members.facade.enums;

import lombok.Getter;

/**
 * 自动标签操作类型枚举
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月04日 13:59:00
 */
@Getter
public enum AutoLabelOperateTypeEnum {

    /**
     * 自动标签操作类型
     */
    CREATE(1,"创建标签"),
    UPDATE_CALCULATE_IMMEDIATELY(2,"修改为立即计算"),
    UPDATE_EVERYDAY_CALCULATE(3,"修改为周期计算"),
    CLICK_CALCULATE_IMMEDIATELY(4,"执行立即计算"),
    UPDATE(5,"编辑"),
    CANCEL_CAL(6, "取消立即计算"),;

    private Integer type;

    private String typeDes;

    AutoLabelOperateTypeEnum(Integer type, String typeDes) {
        this.type = type;
        this.typeDes = typeDes;
    }
}