package com.bizvane.members.facade.vo.vg;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class VGMemberPhoneChangeVo {

    @NotNull
    private Long sysCompanyId ;

    @NotEmpty(message = "会员的集团卡号必须填")
    private String cardNo;

    @NotEmpty(message = "变更前的手机号必须填")
    private String oldPhone;

    @NotEmpty(message = "变更后的手机号必须填")
    private String newPhone;


}
