package com.bizvane.members.facade.enums;

public enum  BindCardEnum {
    /**
     * 会员已绑定标志
     */
    ALREADY_BIND_CARD(1,"会员已绑定"),
    /**
     * 会员绑定成功标志
     */
    SUCCESS_BIND_CARD(2, "绑定成功"),
    /**
     * 会员不可绑定标志
     */
    FAILED_BIND_CARD(3, "会员不存在,不可绑定");


    private Integer code;

    private String msg;

    BindCardEnum(Integer code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (BindCardEnum type : BindCardEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }
}
