package com.bizvane.members.facade.utils;

import com.alibaba.fastjson.JSON;
import com.bizvane.connectorservice.util.MD5Util;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

@Slf4j
public class DuplicateRequestHelper {

    /**
     * 请求Json数据
     * @param reqJSON
     * @param excludeKeys
     * @return
     */
    public static String md5forReqParam(final String reqJSON, String... excludeKeys) {

        TreeMap<?,?> paramTreeMap = JSON.parseObject(reqJSON, TreeMap.class);
        if (excludeKeys!=null) {
            List<String> dupRequestParamExcludeKeys = Arrays.asList(excludeKeys);
            if (!dupRequestParamExcludeKeys.isEmpty()) {
                for (String dupRequestParamExcludeKey : dupRequestParamExcludeKeys) {
                    paramTreeMap.remove(dupRequestParamExcludeKey);
                }
            }
        }
        String paramTreeMapJSON = JSON.toJSONString(paramTreeMap);
        String md5deDupParam = MD5Util.md5Encode(paramTreeMapJSON);
        log.debug("md5deDupParam = {}, excludeKeys = {} {}", md5deDupParam, Arrays.deepToString(excludeKeys), paramTreeMapJSON);
        return md5deDupParam;
    }

    public static void main(String[] args) {
        String str = "{'A':'SwWW','B':'12312'}";
        System.out.println(DuplicateRequestHelper.md5forReqParam(str));
        System.out.println(DuplicateRequestHelper.md5forReqParam(str));
        System.out.println(DuplicateRequestHelper.md5forReqParam(str, "B"));
    }
}
