package com.bizvane.members.facade.vo;

import com.bizvane.members.facade.models.IntegralRecordModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/16.
 */
@Data
public class IntegralRecordVo extends IntegralRecordModel {

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "开始时间", name = "startTime")
    private Date startTime;

    private String startTimeStr;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "结束时间", name = "endTime")
    private Date endTime;

    private String endTimeStr;

    @ApiModelProperty(value = "会员卡等级名称", name = "levelName")
    private String levelName;

    @ApiModelProperty(value = "流水年份", name = "year")
    private String year;

    @ApiModelProperty(value = "当前页", name = "pageNum")
    private int pageNum;

    @ApiModelProperty(value = "每页记录数", name = "pageNum")
    private int pageSize;

    @ApiModelProperty(value = "业务类型", name = "businessIds")
    private Long[] businessIds;

    @ApiModelProperty(value = "线下积分类型",name = "t_mbr_integral_record_business_type表中business_code")
    private List<String> businessCodes;

    @ApiModelProperty(value = "所属俱乐部",name = "club")
    private String club;

    @ApiModelProperty(value = "集团卡",name = "masterCard")
    private Boolean masterCard;

    @ApiModelProperty(value = "所有会员集合",name = "memberCodes")
    private List<String> memberCodes;
}
