package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrGroupTypeModel;
import com.bizvane.members.facade.vo.MbrGroupTypeVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/17 17:33
 * @Description:
 */
public interface MemberGroupTypeService {
    /**
     * 新建分组类型
     *
     * @param mbrGroupTypeModel
     * @return
     * @throws MemberException
     */
    ResponseData addGroupType(MbrGroupTypeModel mbrGroupTypeModel) throws MemberException;

    /**
     * 查询品牌下所有分组类型
     *
     * @param brandId
     * @return
     */
    ResponseData<List<MbrGroupTypeModel>> queryGroupTypeList(long brandId,String onlineOrgCode);

    /**
     * 删除分组类型
     *
     * @param mbrGroupTypeModel
     * @return
     * @throws MemberException
     */
    ResponseData deleteGroupType(MbrGroupTypeModel mbrGroupTypeModel) throws MemberException;

    /**
     * 查询会员分组类型详情
     *
     * @param mbrGroupTypeDefId
     * @return
     */
    ResponseData<MbrGroupTypeModel> queryGroupTypeInfo(long mbrGroupTypeDefId);

    /**
     * 编辑会员分组类型
     * @param mbrGroupTypeModel
     * @return
     */
    ResponseData updateGroupType(MbrGroupTypeModel mbrGroupTypeModel);


    /**
     * 查询分组列表
     */
    ResponseData<List<MbrGroupTypeVo>> queryAllBrandGroupList(Long sysCompanyId, Long brandId,String onlineOrgCode);

}
