package com.bizvane.members.facade.vo.qywx;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.ToString;

@ToString
@ApiModel("新增自定义标签")
public class AddCustomizeLabelRequestVO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "企业id", name = "sysCompanyId", required = true)
  @NotNull 
  private Long sysCompanyId;
  
  @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
  @NotNull 
  private Long brandId;
  
  @ApiModelProperty(value = "标签名称", name = "labelName", required = true)
  @NotBlank 
  private String labelName;
  
  @ApiModelProperty(value = "创建人id", name = "createUserId", required = true)
  @NotNull 
  private Long createUserId;
  
  @ApiModelProperty(value = "创建人", name = "createUserName", required = true)
  @NotBlank 
  private String createUserName;

  public Long getBrandId() {
    return brandId;
  }

  public void setBrandId(Long brandId) {
    this.brandId = brandId;
  }

  public String getLabelName() {
    return labelName;
  }

  public void setLabelName(String labelName) {
    this.labelName = labelName;
  }

  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  public Long getSysCompanyId() {
    return sysCompanyId;
  }

  public void setSysCompanyId(Long sysCompanyId) {
    this.sysCompanyId = sysCompanyId;
  }

  
}
