package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.AutoLabelListVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxGroupSearchRequestVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxLabelRequestVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxLabelResponseVo;
import com.bizvane.members.facade.vo.qywx.CompanyWxLabelSearchRequestVo;
import com.bizvane.members.facade.vo.qywx.GroupFirstLevelResponseVo;
import com.bizvane.members.facade.vo.qywx.MainIndexResponseVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface CompanyWxLabelSetApiService {

	/**
	 * // 中间会员标签设置查询接口
	 * @param brandId
	 * @return
	 */
	@RequestMapping(value = "/api/companyWxLabel/queryByBrandId", method = RequestMethod.POST)
	ResponseData queryByBrandId(@RequestParam(value = "brandId") Long brandId);

	/**
	 * // 中间会员标签设置查询接口
	 * @param brandId
	 * @return
	 */
	@RequestMapping(value = "/api/companyWxLabel/queryByBrandIdAndName", method = RequestMethod.POST)
	ResponseData queryByBrandIdAndName(@RequestParam(value = "brandId") Long brandId, @RequestParam(name = "labelName",required = false) String labelName);


	/**
	 * 查询自动标签分组下的自动标签 分页
	 *
	 * @param autoLabelName     自动标签名称
	 * @param autoLabelGroupId  自动标签分组id
	 * @param sysCompanyId      企业id
	 * @param brandId           品牌id
	 * @param pageNum
	 * @param pageSize
	 * @return ResponseData<PageInfo<AutoLabelListVo>>
	 */
	@RequestMapping(value = "/api/companyWxLabel/selectAutoLabels", method = RequestMethod.POST)
	ResponseData<PageInfo<AutoLabelListVo>> selectAutoLabels(@RequestParam(value = "autoLabelName")String autoLabelName,
															 @RequestParam(value = "autoLabelGroupId")Long autoLabelGroupId,
															 @RequestParam(value = "sysCompanyId")Long sysCompanyId,
															 @RequestParam(value = "brandId")Long brandId,
															 @RequestParam(value = "pageNum")Integer pageNum,
															 @RequestParam(value = "pageSize")Integer pageSize);


	/**
	 * // 首页列表取6个常用二级分组
	 * @param brandId
	 * @param storeId
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/companyWxLabel/get6MainIndexLabel", method = RequestMethod.POST)
	/**
	 * //作废
	 */
	ResponseData<List<MainIndexResponseVo>> get6MainIndexSecondLabel(@RequestParam(value = "brandId") Long brandId,
			@RequestParam(value = "storeId") Long storeId) throws MemberException;

	/**
	 * brandId 店铺id storeList 店铺list serviceGuide 导购id
	 * 
	 * @param brandId
	 * @param storeId
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/companyWxLabel/get6MainIndexLabelNew", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> get6MainIndexLabelNew(
			@RequestBody CompanyWxLabelRequestVo companyWxLabelRequestVo) throws MemberException;

	/**
	 * // 品牌下所有一级分组
	 * @param brandId
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/companyWxLabel/getAllFirstLevelLabel", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> getAllFirstLevelLabel(@RequestParam(value = "brandId") Long brandId)
			throws MemberException;

	/**
	 * // 一级分组下的所有二级分组
	 * @param companyWxLabelRequestVo
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/companyWxLabel/getSecondLabelByFirstLevelLabel", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> getSecondLabelByFirstLevelLabel(
			@RequestBody CompanyWxLabelRequestVo companyWxLabelRequestVo) throws MemberException;

	/**
	 * // 查二级分组下的会员
	 * @param companyWxLabelRequestVo
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/companyWxLabel/getLabelMembers", method = RequestMethod.POST)
	ResponseData<CompanyWxLabelResponseVo> getLabelMembers(@RequestBody CompanyWxLabelRequestVo companyWxLabelRequestVo)
			throws MemberException;

	@RequestMapping(value = "/api/companyWxLabel/searchLabel", method = RequestMethod.POST)
	ResponseData<List<GroupFirstLevelResponseVo>> searchLabel(
			@RequestBody CompanyWxLabelSearchRequestVo companyWxLabelSearchRequestVo);
}
