package com.bizvane.members.facade.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * @Author: houkai
 * @Date: 2018/8/8 20:03
 * @Description: 全局业务类型
 */
public enum BusinessTypeEnum {

    /**
     * 积分过期
     */
    INTEGER_PAST_DUE("1", "积分过期"),
    /**
     * 积分过期
     */
    INTEGER_RESERVE("2", "保留原积分"),
    /**
     * 积分过期
     */
    INTEGER_REST("3", "积分清零"),
    /**
     * 积分过期
     */
    INTEGER_ADJUST_EXPEND("4", "手动调整支出"),
    /**
     * 积分过期
     */
    INTEGER_ADJUST_INCOME("5", "手动调整获取"),
    /**
     * 积分过期
     */
    INTEGER_CONSUME_INCOME("6", "商品消费获取"),
    /**
     * 积分过期
     */
    INTEGER_EXCHANGE_EXPEND("7", "积分兑换支出"),
    /**
     * 积分过期
     */
    INTEGER_GAME_EXPEND("8", "游戏消耗支出"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_REGISGER("9", "开卡活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_SMART("10", "智能营销活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_UPGRADE("11", "升级活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_QRCODE("12", "扫码领券活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_MANUAL("13", "手动领券活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_ORDER("14", "消费活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_SIGNIN("15", "签到活动"),
    /**
     * 积分过期
     */
    ACTIVITY_TYPE_BIRTHDAY("16", "生日活动"),
    /**
     * 积分过期
     */
    TASK_TYPE_PREFECT("17", "完善资料任务"),
    /**
     * 积分过期
     */
    TASK_TYPE_SHARE("18", "微信分享任务"),
    /**
     * 积分过期
     */
    TASK_TYPE_COMSUMPTION_MONEY("19", "消费金额任务"),
    /**
     * 积分过期
     */
    TASK_TYPE_COMSUMPTION_COUNT("20", "消费次数任务"),
    /**
     * 积分过期
     */
    TASK_TYPE_INVITATION_OPENCARD("21", "邀请开卡任务"),
    /**
     * 积分过期
     */
    TASK_TYPE_MEMORIAL_DAY("22", "纪念日活动"),
    /**
     * 积分过期
     */
    TASK_TYPE_EVALUATE_AWARD("23", "评价奖励活动"),
    /**
     * 积分过期
     */
    OFFLINE_HAND_TYPE("24", "线下手动调整"),
    /**
     * 积分过期
     */
    OFFLINE_ACTIVITY_TYPE("25", "线下活动调整"),
    /**
     * 积分过期
     */
    INTEGRAL_EXCHANGE_COUPON("26", "积分兑换券"),
    /**
     * 积分过期
     */
    SOCIAL_AFFAIR("27", "转盘活动"),
    /**
     * 积分过期
     */
    RED_PACKET_EXPAND_ACTIVIEY("28", "红包膨胀活动"),
    /**
     * 积分过期
     */
    SMASH_EGG_ACTIVITY("29", "砸金蛋活动"),
    /**
     * 积分过期
     */
    INTEGRAL_MALL_CONSUME("30", "积分商城消费积分"),
    /**
     * 积分过期
     */
    INTEGRAL_MALL_RETURN("31", "积分商城返还积分"),
    /**
     * 积分过期
     */
    ACTIVITY_FIRST_ORDER("32", "首单开卡活动"),
    /**
     * 积分过期
     */
    ACTIVITY_BABY_BIRTH("33", "宝宝生日活动"),
    /**
     * 积分过期
     */
    EXCHANGE_OTHER_CONSUME("34", "兑换有赞积分"),
    /**
     * 积分过期
     */
    MICRO_MALL_DECREASE("35", "微商城积分扣减"),
    /**
     * 积分过期
     */
    MICRO_MALL_INCREASE("36", "微商城积分返还"),
    /**
     * 积分过期
     */
    COMPENSATION_INTEGRAL("-1", "积分补偿"),
    /**
     * 积分过期
     */
    SHAKE_AND_SHAKE("37", "摇一摇"),
    /**
     * 积分过期
     */
    RECHARGE_SEND_GIFT("38", "储值送礼"),

    /**
     * 积分过期
     */
    COMMISSION_EXCHANGE("39","佣金兑换"),
    /**
     * 积分过期
     */
    GIFT_EXCHANGE("40","天猫消费积分"),
    /**
     * 积分过期
     */
    OFFLINE_INTEGRAL_CHANGE("41","积分变更"),
    /**
     * 积分过期
     */
    TASK_TYPE_QUESTIONNAIRE("42", "调查问卷任务"),
    /**
     * 积分过期
     */
    INTEGER_TRANSFER("43", "积分转赠"),
    /**
     * 积分过期
     */
    INTEGER_RECIPIENT("44", "积分受赠"),

    YOUZAN_API_EXCHANGE("45","有赞积分接口处理"),
    YOUZAN_INIT("46","有赞积分初始化"),
    ///ur
    /**
     * 积分过期
     */
    UR_GIVE_AWAY("100", "赠送"),
    /**
     * 积分过期
     */
    UR_CONSUME("101", "消费"),
    /**
     * 积分过期
     */
    UR_SALES_RETURN("102", "退货"),
    /**
     * 积分过期
     */
    UR_ADJUST_DECREASE("103", "积分调整减积分"),
    /**
     * 积分过期
     */
    UR_ADJUST_INCREASE("104", "积分调整增积分"),
    /**
     * 积分过期
     */
    UR_EXCHANGE("105", "积分兑换"),
    /**
     * 积分过期
     */
    UR_CASH("106", "积分抵现"),
    /**
     * 积分过期
     */
    UR_CASH_RETURN("107", "积分抵现返还"),
    /**
     * 积分过期
     */
    UR_ZERO("108", "积分清零"),
    /**
     * 积分过期
     */
    UR_RETURN("109", "赠送退回"),
    /**
     * 积分过期
     */
    UR_OTHER("110", "其它"),
    WEBHOOK("111", "用户营销调整"),

    /**
     * 受邀开卡奖励积分
     */
    SEND_INTEGRAL_INVITEED_OPENCARD_TASK("116", "受邀开卡奖励积分"),

    /**
     * 百胜初始建档
     */
    BAISON_INITIAL_FILE("113", "初始建档"),
    /**
     * 百胜积分调整
     */
    BAISON_POINTS_ADJUSTMENT("114", "积分调整"),
    /**
     * 百胜充值积分
     */
    BAISON_RECHARGE_POINTS("115", "充值积分"),

    /**
    * 泰迪积分券加积分，陈俊勇，宋江浩需求
    * */
    TAIDI_INTEGRALCOUPON_ADDPOINTS("117","积分券兑换"),

    VG_INTEGRAL_RECHARGE("118","积分充值")
    ;
    private String code;

    private String msg;

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    BusinessTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getBusinessTypeMessage(String code) {
        for (BusinessTypeEnum type : BusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }

    /**
     * 根据枚举code获得枚举
     *
     * @param code
     * @return
     */
    public static BusinessTypeEnum getBusinessTypeEnum(String code) {
        for (BusinessTypeEnum type : BusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public static BusinessTypeEnum getBusinessCodeEnum(String msg) {
        for (BusinessTypeEnum type : BusinessTypeEnum.values()) {
            if (type.getMsg().equals(msg)) {
                return type;
            }
        }
        return null;
    }

    /**
     * 将该枚举全部转化成json
     *
     * @return
     */
    public static JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        for (BusinessTypeEnum e : BusinessTypeEnum.values()) {
            JSONObject object = new JSONObject();
            object.put("typeId", e.getCode());
            object.put("typeName", e.getMsg());
            jsonArray.add(object);
        }
        return jsonArray;
    }
}
