package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/13.
 */
public enum OpenCardChannelEnum {
    /**
     * 会员开卡绑卡渠道 线下渠道
     */
    OFFLINE_CHANNEL(1L,"100001", "线下渠道"),
    /**
     * 会员开卡绑卡渠道 微信渠道
     */
    WECHAT_CHANNEL(2L, "100002","微信小程序渠道"),
    /**
     * 会员开卡绑卡渠道 支付宝渠道
     */
    ALIPAY_CHANNEL(3L, "100003","支付宝小程序渠道"),
    /**
     * 会员开卡绑卡渠道 天猫渠道
     */
    TAOBAO_CHANNEL(4L, "100004","天猫渠道"),
    /**
     * 会员开卡绑卡渠道 电子会员卡渠道
     */
    ELECTCARD_CHANNEL(5L, "100005","微信电子会员卡渠道"),
    /**
     * 会员开卡绑卡渠道 微商城
     */
    MALL(6L, "100006","锦集商城"),
    /**
     * 会员开卡绑卡渠道 手动导入渠道
     */
    IMPORT_CHANNEL(7L,"100007", "手动导入渠道"),
    /**
     * 会员开卡绑卡渠道 微盟商城
     */
    MALL_WEIMOB_CHANNEL(8L, "100008","微盟商城"),
    /**
     * 会员开卡绑卡渠道 EHR
     */
    EHR(9L,"100009","EHR"),
    /**
     * 会员开卡绑卡渠道 其它渠道
     */
    OTHER_CHANNEL(10L,"100010","其它渠道"),
    /**
     * 会员开卡绑卡渠道 有赞渠道
     */
    YOUZAN_CHANNEL(11L,"100011","有赞渠道"),
    /**
     * 会员开卡绑卡渠道 支付宝渠道
     */
    ALIPAY_CARD_CHANNEL(12L, "100012","支付宝电子会员卡渠道");
    private Long code;

    private String channelCode;

    private String msg;

    OpenCardChannelEnum(Long code, String channelCode, String msg) {
        this.code = code;
        this.channelCode = channelCode;
        this.msg = msg;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getChannelCode() {
        return channelCode;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getOpenCardChanneMessage(Long code) {
        for (OpenCardChannelEnum type : OpenCardChannelEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }
}
