package com.bizvane.members.facade.models.bo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 会员好友BO
 *
 * @author ljc
 * @since 2020年10月23日 14:50:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MemberFriendBO {

    /**
     * 好友姓名
     */
    private String friendName;

    /**
     * 好友生日  yyyy-mm-dd
     */
    private String friendBirthday;

    /**
     * 好友性别 1.女 2.男 3.未知
     */
    private Integer friendGender;

    /**
     * 好友手机
     */
    private String friendPhone;

    /**
     * 好友关系 1好友
     */
    private Integer friendRelation;

    /**
     * 备注
     */
    private String remark;

    /**
     * 有效状态 ：1.有效 0.无效
     */
    private Integer valid;

}
