package com.bizvane.members.facade.enums;

import lombok.Getter;

/**
 * 自动标签状态枚举
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月04日 16:00:00
 */
@Getter
public enum AutoLabelStatusEnum {
    /**
     * 自动标签状态
     */
    NORMAL(1,"正常状态"),
    CLICK(2,"点击立即计算"),
    CALCULATE(3,"大数据计算中"),
    WRITE(4,"CRM写入中"),;

    private Integer status;

    private String msg;

    AutoLabelStatusEnum(Integer status, String msg) {
        this.status = status;
        this.msg = msg;
    }
}
