package com.bizvane.members.facade.service.card.response;

import com.bizvane.centerstageservice.models.po.SysStorePo;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Data
@Builder
@ToString
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode
public class PushMbrModel {


    /**
     * 基础信息
     */
    @ApiModelProperty(name = "sysCompanyId", value = "sysCompanyId")
    private Long sysCompanyId;
    @ApiModelProperty(name = "brandId", value = "brandId")
    private Long brandId;

    @ApiModelProperty(name = "appId", value = "appId")
    private String appId;

    @ApiModelProperty(name = "publicId", value = "publicId")
    private Long publicId;

    @ApiModelProperty(name = "unionId", value = "unionId")
    private String unionId;

    @ApiModelProperty(name = "openId", value = "openId")
    private String openId;

    @ApiModelProperty(name = "wxNick", value = "微信昵称")
    private String wxNick;

    @ApiModelProperty(name = "headPortraits", value = "微信头像")
    private String headPortraits;

    @ApiModelProperty(name = "name", value = "姓名")
    private String name;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "gender", value = "性别")
    private String gender;

    @ApiModelProperty(name = "birthday", value = "生日")
    private Date birthday;

    @ApiModelProperty(name = "birthdayMd", value = "生日MMdd")
    private String birthdayMd;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "city", value = "城市")
    private String city;

    @ApiModelProperty(name = "county", value = "区县")
    private String county;

    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;

    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;

    @ApiModelProperty(name = "idCard", value = "身份证")
    private String idCard;


    @ApiModelProperty(name = "erpId", value = "线下id")
    private String erpId;

    @ApiModelProperty(name = "barCode", value = "二维码code")
    private String barCode;
    /**
     * 会员信息
     */

    @ApiModelProperty(name = "memberCode", value = "会员code")
    private String memberCode;

    @ApiModelProperty(name = "openCardTime", value = "开卡时间")
    private Date openCardTime;

    @ApiModelProperty(name = "bindCardTime", value = "绑卡时间")
    private Date bindCardTime;

    @ApiModelProperty(name = "levelId", value = "等级id")
    private Long levelId;

    @ApiModelProperty(name = "levelName", value = "等级名称")
    private String levelName;

    @ApiModelProperty(name = "countIntegral", value = "累计可用积分")
    private Integer countIntegral;

    @ApiModelProperty(name = "cardNo", value = "线上卡号")
    private String cardNo;

    @ApiModelProperty(name = "offlineCardNo", value = "线下卡号")
    private String offlineCardNo;

    @ApiModelProperty(name = "storesName", value = "门店")
    private String storesName;

    @ApiModelProperty(value = "开卡店铺id", name = "openCardStoreId")
    private Long openCardStoreId;

    @ApiModelProperty(value = "开卡导购id", name = "openCardGuideId")
    private Long openCardGuideId;

    @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
    private Long serviceGuideId;

    @ApiModelProperty(value = "服务导购店铺id", name = "serviceStoreId")
    private Long serviceStoreId;

    @ApiModelProperty(name = "cardStatus", value = "绑卡状态：1绑卡、2未帮卡")
    private Integer cardStatus;

    @ApiModelProperty(name = "operateType", value = "操作类型:0.已绑过,1绑卡，2注册")
    private Integer operateType;

    @ApiModelProperty(value = "注册时间", name = "注册时间")
    private String inviteRegisterTime;

    @ApiModelProperty(value = "有效时间", name = "有效时间")
    private Date effectiveTime;


    //线下code字段
    @ApiModelProperty(name = "offlineCompanyCode", value = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(name = "offlineBrandCode", value = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(name = "offlineLevelCode", value = "等级code")
    private String offlineLevelCode;

    @ApiModelProperty(name = "openCardStoreCode", value = "开卡门店code")
    private String openCardStoreCode;

    @ApiModelProperty(name = "openCardGuideCode", value = "开卡导购code")
    private String openCardGuideCode;

    @ApiModelProperty(name = "serviceStoreCode", value = "服务门店code")
    private String serviceStoreCode;

    @ApiModelProperty(name = "serviceGuideCode", value = "服务导购code")
    private String serviceGuideCode;

    @ApiModelProperty(name = "activeStore", value = "活跃门店")
    private String activeStore;

    @ApiModelProperty(name = "cardUseStatus", value = "vip卡状态 0未激活 1激活 2停用 3挂失 4冻结")
    private Integer cardUseStatus;

    @ApiModelProperty(name = "valid", value = "0无效 1有效")
    private Integer valid;

    @ApiModelProperty(name = "addUpIntegral", value = "累计收入的总积分")
    private Integer addUpIntegral;

    private Integer aboutExpireIntegral;
    private Date aboutExpireTime;//即将到期时间
    private Date offlineUpdateDate;// datetime DEFAULT NULL COMMENT '线下更新时间',
    private Integer pastDueIntegral;// int(11) DEFAULT '0' COMMENT '已过期积分',
    private Integer consumeIntegral;// int(11) DEFAULT '0' COMMENT '已消耗积分',
    private Integer freezeIntegral;// int(11) DEFAULT '0' COMMENT '冻结积分',


    private Date offlineUpdateIntegralDate;// datetime DEFAULT NULL COMMENT '会员积分线下更新时间',
    private BigDecimal balance;// decimal(11,2) DEFAULT '0.00' COMMENT '会员余额',
    private Date babyBirthday;// date DEFAULT NULL COMMENT '宝宝生日',
    private String babyBirthdayMd; //varchar(10) DEFAULT NULL COMMENT '宝宝生日 MMdd',
    private String petCard;// varchar(50) DEFAULT NULL COMMENT '储值卡号',
    private Date offlineUpdateBalanceDate;// datetime DEFAULT NULL,
    private Integer registerType;// int(2) DEFAULT NULL COMMENT 'ur注册类型',
    private Integer emailStatus;// int(1) DEFAULT NULL COMMENT '邮箱验证状态 0未验证 1已验证',
    private Integer firstLandingCheck;//首次登陆


    /**
     * 业务类型
     */
    @ApiModelProperty(name = "sceneId", value = "业务类型id")
    private Long sceneId;

    @ApiModelProperty(name = "sceneValue", value = "业务类型值")
    private String sceneValue;

    @ApiModelProperty(name = "sourceWay", value = "业务类型")
    private String sourceWay;


    /**
     * 集团卡信息
     */
    @ApiModelProperty(name = "masterBrandId", value = "集团卡品牌")
    private Long masterBrandId;

    @ApiModelProperty(name = "memberElectCardCode", value = "会员电子电子会员卡Code")
    private String memberElectCardCode;

    @ApiModelProperty(name = "mqMsgId", value = "mqMsgId")
    private String mqMsgId;

}
