package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.vo.MemberElectCardResVo;
import com.bizvane.members.facade.vo.MemberElectCardSearchVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author zcc
 * @date 2021/8/8 16:12
 **/
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberElectCardApiService {
    /**
     * 根据unionId 查询该微信电子会员卡信息
     * @param memberElectCardSearchVo
     * @return
     */
    @PostMapping(value = "/api/getMemberElectCardByWx")
    ResponseData<MemberElectCardResVo> getMemberElectCardByWx(@RequestBody MemberElectCardSearchVo memberElectCardSearchVo);
}
