/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.members.facade.vo.ConsumeRecordVo;
import com.bizvane.members.facade.vo.MemberInfoCardVo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberDesensitizeUtil {
    private static final Logger log = LoggerFactory.getLogger(MemberDesensitizeUtil.class);

    public static void encryptMemberInfoVo(MemberInfoVo memberInfoVo) {
        if (Objects.nonNull(memberInfoVo)) {
            memberInfoVo.setPhone(DesensitizeUtil.encrypt(memberInfoVo.getPhone()));
        }
    }

    public static void encryptConsumeRecordVo(ConsumeRecordVo consumeRecordVo) {
        if (Objects.nonNull(consumeRecordVo)) {
            consumeRecordVo.setCardNo(DesensitizeUtil.encrypt(consumeRecordVo.getCardNo()));
        }
    }

    public static void encryptMemberInfoCardVo(MemberInfoCardVo memberInfoCardVo) {
        if (Objects.nonNull(memberInfoCardVo)) {
            memberInfoCardVo.setCardNo(DesensitizeUtil.encrypt(memberInfoCardVo.getCardNo()));
            memberInfoCardVo.setErpid(DesensitizeUtil.encrypt(memberInfoCardVo.getErpid()));
        }
    }

    public static void encryptIntegralRecordModel(IntegralRecordModel integralRecordModel) {
        if (Objects.nonNull(integralRecordModel)) {
            integralRecordModel.setCardNo(DesensitizeUtil.encrypt(integralRecordModel.getCardNo()));
            integralRecordModel.setMemberCardNo(DesensitizeUtil.encrypt(integralRecordModel.getMemberCardNo()));
            integralRecordModel.setMemberPhone(DesensitizeUtil.encrypt(integralRecordModel.getMemberPhone()));
            integralRecordModel.setErpId(DesensitizeUtil.encrypt(integralRecordModel.getErpId()));
        }
    }

    public static void encryptMemberInfoVo(MbrGroupModel mbrGroupModel) {
        if (Objects.nonNull(mbrGroupModel) && StringUtils.isNotBlank((CharSequence)mbrGroupModel.getConditions())) {
            try {
                String mobileStr;
                JSONObject phoneBatchObj;
                JSONObject mbrGroupModelObj = JSON.parseObject((String)mbrGroupModel.getConditions());
                if (Objects.nonNull(mbrGroupModelObj) && Objects.nonNull(phoneBatchObj = mbrGroupModelObj.getJSONObject("phoneBatch")) && StringUtils.isNotBlank((CharSequence)(mobileStr = phoneBatchObj.getString("mobile")))) {
                    String[] mobileArr = mobileStr.split(",");
                    ArrayList<String> mobileDesensitizeList = new ArrayList<String>(mobileArr.length);
                    for (int i = 0; i < mobileArr.length; ++i) {
                        String mobile = mobileArr[i];
                        String mobileDesensitize = DesensitizeUtil.encrypt(mobile);
                        mobileDesensitizeList.add(mobileDesensitize);
                    }
                    String mobileDesensitizeStr = StringUtils.join((Object[])new List[]{mobileDesensitizeList});
                    phoneBatchObj.put("mobile", (Object)mobileDesensitizeStr);
                    mbrGroupModel.setConditions(JSON.toJSONString((Object)mbrGroupModelObj));
                }
            }
            catch (Exception e) {
                log.error("JSON.parseObject error", (Throwable)e);
            }
        }
    }
}

