package com.bizvane.members.facade.service.tmall;

import com.bizvane.members.facade.vo.MbrCouponAuthTmallVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * Created by admin on 2019/9/6.
 * 天猫券授权数据
 */

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MbrCouponAuthTmallService {

    /**
     * 查询天猫券授权页面数据
     *
     * @param mbrCouponAuthTmallVo
     * @return
     */
    @RequestMapping(value = "/mbrCouponAuthTmall/getMbrCouponAuthTmall",method = RequestMethod.POST)
    ResponseData<MbrCouponAuthTmallVo> getMbrCouponAuthTmall(
            @RequestBody @Valid MbrCouponAuthTmallVo mbrCouponAuthTmallVo);


    /**
     * 保存更新天猫券授权数据
     *
     * @param mbrCouponAuthTmallVo
     * @return
     */
    @RequestMapping(value = "/mbrCouponAuthTmall/addAndUpdateMbrCouponAuthTmall")
    ResponseData addAndUpdateMbrCouponAuthTmall(
            @RequestBody @Valid MbrCouponAuthTmallVo mbrCouponAuthTmallVo);

    /**
     * 组装url响应前台
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/mbrCouponAuthTmall/getCouponAuthTmallUrl")
    ResponseData getCouponAuthTmallUrl();

    /**
     * 回调接口，更新天猫券的授权状态
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "/mbrCouponAuthTmall/updateCouponAuthTmallStatus")
    ResponseData updateCouponAuthTmallStatus(
            @RequestBody @Valid MbrCouponAuthTmallVo vo);
}
