package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.es.pojo.BasicMembersInfoSearchPojo;
import com.bizvane.members.facade.vo.GroupAnalyzeSearchVo;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.es.pojo.MembersGroupAnalyzePojo;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.es.vo.MembersGroupAnalyzeSearchVo;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * Created by Administrator on 2018\8\22 0022.
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MembersAdvancedSearchApiService {

	@RequestMapping(value = "/api/memberInfo/queryMemberInfoList", method = RequestMethod.POST)
	ResponseData<PageInfo<MemberInfoVo>> search(@RequestBody MembersInfoSearchVo membersInfoSearchVo);
	
	@RequestMapping(value = "/api/memberInfo/queryAdvancedMemberInfoList", method = RequestMethod.POST)
	ResponseData<PageInfo<MembersInfoSearchPojo>> advancedSearch(@RequestBody MembersInfoSearchVo membersInfoSearchVo);


	@RequestMapping(value = "/api/memberInfo/searchGroupAnalyze", method = RequestMethod.POST)
	ResponseData<PageInfo<BasicMembersInfoSearchPojo>> searchGroupAnalyze(@RequestBody GroupAnalyzeSearchVo groupAnalyzeSearchVo);
}
