package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.es.pojo.MemberNamePojo;
import com.bizvane.members.facade.es.pojo.MembersInfoSearchPojo;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.CompanyMemberInfoBo;
import com.bizvane.members.facade.models.bo.GetMemberDeductionInfo;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.models.query.MemberPhonePo;
import com.bizvane.members.facade.vo.MemberBalanceVO;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.members.facade.vo.WxMemberRequestInfo;
import com.bizvane.members.facade.vo.WxMemberResponseInfo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/18. 会员信息接口，外部调用
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberInfoApiService {

    /**
     * 获取会员信息列表
     *
     * @param memberInfoApiModel
     * @return
     */
    @RequestMapping(value = "/api/getMemberInfo", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberInfoModel>> getMemberInfo(@RequestBody MemberInfoApiModel memberInfoApiModel)
            throws MemberException;

    /**
     * 获取会员个人信息(memberCode,phone,brandId,levelId,erpId)
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getMemberModel", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> getMemberModel(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 高级搜索查询会员个人信息
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getMemberModelByES", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> getMemberModelByES(@RequestBody MemberInfoModel memberInfoModel)
            throws MemberException;

    /**
     * 根据会员code查询会员信息
     *
     * @param pageNumber
     * @param pageSize
     * @param name
     * @param phone
     * @param membersCode
     * @return
     */
    @RequestMapping(value = "/api/getMemberInfoByMembersCode", method = RequestMethod.POST)
    ResponseData<PageInfo<MemberInfoModel>> getMemberInfoByMembersCode(
            @RequestParam(value = "pageNumber") Integer pageNumber, @RequestParam(value = "pageSize") Integer pageSize,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "phone", required = false) String phone,
            @RequestParam(value = "membersCode") String membersCode);

    /**
     * 插入会员信息
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/insertMemberInfo", method = RequestMethod.POST)
    ResponseData insertMemberInfo(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 修改会员信息
     *
     * @param memberInfoModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateMemberInfo", method = RequestMethod.POST)
    ResponseData updateMemberInfo(@RequestBody MemberInfoModel memberInfoModel) throws MemberException;

    /**
     * 获取用户是否分销
     *
     * @param memberCode 会员code
     * @param brandId    品牌ID
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getMemberInfoDistributionState", method = RequestMethod.POST)
    ResponseData<Integer> getMemberInfoDistributionState(@RequestParam(value = "memberCode") String memberCode,
                                                         @RequestParam(value = "brandId") Long brandId) throws MemberException;

    /**
     * 根据phoneList查询会员信息
     *
     * @param memberPhonePo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getMemberInfoByPhones", method = RequestMethod.POST)
    ResponseData<Iterable<MembersInfoSearchPojo>> getMemberInfoByPhones(@RequestBody MemberPhonePo memberPhonePo)
            throws MemberException;

    /**
     * 根据会员codeList查询会员信息
     *
     * @param couponMemberPo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getMemberInfoByCodeList", method = RequestMethod.POST)
    ResponseData<List<MemberInfoModel>> getMemberInfoByCodeList(@RequestBody CouponMemberPo couponMemberPo)
            throws MemberException;

    /**
     * 企微用，根据po查会员信息(旧版本使用getMemberInfoByCodeList)
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getCompanyWxMemberInfo", method = RequestMethod.POST)
    ResponseData<List<CompanyMemberInfoBo>> getCompanyWxMemberInfo(@RequestBody CouponMemberPo couponMemberPo)
            throws MemberException;


    /**
     * 企微用，根据po查会员信息 根据lastchattime排序
     * 带分页(默认查10页)
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getCompanyWxMemberInfoPageable", method = RequestMethod.POST)
    ResponseData<PageInfo<CompanyMemberInfoBo>> getCompanyWxMemberInfoPageable(@RequestBody CouponMemberPo couponMemberPo)
            throws MemberException;


    /**
     * 企微用 根据po查会员
     * @param couponMemberPo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getCommonWxMemberInfoPageable", method = RequestMethod.POST)
    ResponseData<PageInfo<CompanyMemberInfoBo>> getCommonWxMemberInfoPageable(@RequestBody @Valid CouponMemberPo couponMemberPo)
            throws MemberException;


    /**
     * 根据会员手机号查询会员名称
     *
     * @param couponMemberPo
     * @return
     */
    @RequestMapping(value = "/api/getMemberNameByPhones", method = RequestMethod.POST)
    ResponseData<Map<String, String>> getMemberNameByPhones(@RequestBody CouponMemberPo couponMemberPo);

    /**
     * 根据cardNoStr 查询会员信息
     *
     * @param couponMemberPo
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getMemberInfoByCardNoStr", method = RequestMethod.POST)
    ResponseData<Iterable<MemberNamePojo>> getMemberInfoByCardNoStr(@RequestBody CouponMemberPo couponMemberPo)
            throws MemberException;

    /**
     * 根据会员id查询会员信息
     *
     * @param mbrMemberId
     * @return
     */
    @RequestMapping(value = "/api/getMemberById", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> getMemberById(@RequestParam(value = "mbrMemberId") Long mbrMemberId);

    /**
     * 获取会员个人信息(memberCode)
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/getSingleMemberModel", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> getSingleMemberModel(@RequestBody MemberInfoModel memberInfoModel)
            throws MemberException;

    /**
     * 根据memberCode查积分信息
     *
     * @param memberCode
     * @return
     */
    @RequestMapping(value = "/api/getCountIntegralByMemberCode", method = RequestMethod.POST)
    ResponseData<Integer> getCountIntegralByMemberCode(@RequestParam(value = "memberCode") String memberCode);

    @RequestMapping(value = "/api/addIntegralExchangeTicketCount", method = RequestMethod.POST)
    ResponseData addIntegralExchangeTicketCount(@RequestParam("memberCode") String memberCode,
                                                @RequestParam("second") Integer second);

    /**
     * 维护会员充值余额
     */
    @Deprecated
    @RequestMapping(value = "/api/updateMemberBalance", method = RequestMethod.POST)
    ResponseData<Integer> updateMemberBalance(@RequestParam("cardNo") String cardNo,
                                              @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("balance") BigDecimal balance);

    /**
     * 余额变动通知
     *
     * @param memberBalanceVO
     * @return
     */
    @RequestMapping(value = "/api/updateMemberBalanceAndSendTempalte", method = RequestMethod.POST)
    ResponseData<Integer> updateMemberBalanceAndSendTempalte(@RequestBody MemberBalanceVO memberBalanceVO);

    /**
     * 根据会员code查询会员余额、会员可用积分、积分抵扣比例
     */
    @RequestMapping(value = "/api/getMemberDeductionInfo", method = RequestMethod.POST)
    ResponseData<GetMemberDeductionInfo> getMemberDeductionInfo(@RequestParam(value = "memberCode") String memberCode);

    /**
     * 扣除积分、余额、写入积分流水、余额流水
     */
    @RequestMapping(value = "/api/updateMemberBalanceAndIntegral", method = RequestMethod.POST)
    ResponseData<Integer> updateMemberBalanceAndIntegral(@RequestBody GetMemberDeductionInfo deductionInfo);

    /**
     * 根据CardNo查余额信息
     *
     * @param cardNo
     * @return
     */
    @RequestMapping(value = "/api/getBalanceByCardNo", method = RequestMethod.POST)
    ResponseData<Integer> getBalanceByCardNo(@RequestParam(value = "cardNo") String cardNo, @RequestParam(value = "brandId") Long brandId);

    /**
     * 根据CardNo查询会员信息
     */
    @RequestMapping(value = "/api/getMemberInfoByCardNo", method = RequestMethod.POST)
    ResponseData<GetMemberDeductionInfo> getMemberInfoByCardNo(@RequestParam(value = "cardNo") String cardNo, @RequestParam(value = "brandId") Long brandId);

    /**
     * 根据memberCode修改petCard
     */
    @RequestMapping(value = "/api/updatePetCardByCardNo", method = RequestMethod.POST)
    ResponseData<Integer> updatePetCardByCardNo(@RequestParam(value = "memberCode") String memberCode, @RequestParam(value = "petCard") String petCard);


    /**
     * 查询余额
     *
     * @param memberCode
     * @param brandId
     * @return
     */
    @RequestMapping(value = "/api/getBalanceByMemberCode", method = RequestMethod.POST)
    ResponseData<BigDecimal> getBalanceByMemberCode(@RequestParam(value = "memberCode") String memberCode, @RequestParam(value = "brandId") Long brandId);


    @RequestMapping(value = "/api/queryBasicMemberInfo", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> queryBasicMemberInfo(@RequestBody MemberInfoModel memberInfoModel);

    /**
     * 根据erpid查询会员信息
     *
     * @param erpId        线下erpId
     * @param brandId      品牌id
     * @param sysCompanyId 公司id
     * @return
     */
    @RequestMapping(value = "/api/queryMemberInfoByErpId", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> queryMemberInfoByErpId(@RequestParam(value = "erpId") String erpId, @RequestParam(value = "brandId") Long brandId, @RequestParam(value = "sysCompanyId") Long sysCompanyId);


    /**
     * 根据erpId查询微信会员信息
     * @param wxMemberRequestInfo
     * @return
     */
    @RequestMapping(value = "/api/queryWxMemberInfo", method = RequestMethod.POST)
    ResponseData<WxMemberResponseInfo> queryWxMemberInfo(@RequestBody @Valid WxMemberRequestInfo wxMemberRequestInfo);
    /**
     * 根据memberCode查会员信息(线下信息)包括线下门店code、导购code
     *
     * @param sysCompanyId
     * @param brandId
     * @param memberCode
     * @return
     */
    @RequestMapping(value = "/api/queryOfflineMemberInfo", method = RequestMethod.POST)
    ResponseData<MemberInfoModel> queryOfflineMemberInfo(@RequestParam(value = "sysCompanyId") Long sysCompanyId, @RequestParam(value = "brandId") Long brandId, @RequestParam(value = "memberCode") String memberCode);


}
