package com.bizvane.members.facade.enums;

public enum FriendsStatusEnum {

    NORMAL(1, "正常"),

    ASSING(2, "待分配"),

    CONFIRM(3, "待确认"),

    DELETE(4, "删除");

    private Integer code;

    private String msg;

    FriendsStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(Integer code) {
        for (FriendsStatusEnum type : FriendsStatusEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }


}
