package com.bizvane.members.facade.service.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.MemberSysResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberSysApiService {

	@RequestMapping(value = "/api/getMemberSysByBrandId", method = RequestMethod.POST)
	public ResponseData<MemberSysResponseVo> getMemberSysByBrandId(@RequestParam("brandId") Long brandId)
			throws MemberException;

}
