package com.bizvane.members.facade.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public enum ExtendOfflinePropertyEnum {

	BABYNAME("babyName", "宝宝名称"),

	BABYSEX("babySex", "宝宝性别"),

	BABYBIRTHDAY("babyBirthday", "宝宝生日"),

	DUEDATE("dueDate", "预产期"),

	EUCURRENCY("euCurrency", "北欧币");

	private String code;

	private String msg;

	public String getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}

	ExtendOfflinePropertyEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	/**
	 * 根据枚举code获得枚举msg
	 *
	 * @param code
	 * @return
	 */
	public static String getExtendOfflineProperty(String code) {
		for (ExtendOfflinePropertyEnum type : ExtendOfflinePropertyEnum.values()) {
			if (type.getCode().equals(code)) {
				return type.getMsg();
			}
		}
		return "";
	}

	/**
	 * 根据枚举code获得枚举
	 *
	 * @param code
	 * @return
	 */
	public static ExtendOfflinePropertyEnum getExtendOfflinePropertyEnum(String code) {
		for (ExtendOfflinePropertyEnum type : ExtendOfflinePropertyEnum.values()) {
			if (type.getCode().equals(code)) {
				return type;
			}
		}
		return null;
	}

	/**
	 * 将该枚举全部转化成json
	 *
	 * @return
	 */
	public static JSONArray toJson() {
		JSONArray jsonArray = new JSONArray();
		for (ExtendOfflinePropertyEnum e : ExtendOfflinePropertyEnum.values()) {
			JSONObject object = new JSONObject();
			object.put("typeId", e.getCode());
			object.put("typeName", e.getMsg());
			jsonArray.add(object);
		}
		return jsonArray;
	}
}
