package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.UrIntegralRequestVo;
import com.bizvane.members.facade.ur.vo.UrIntegralResponseVo;
import com.bizvane.members.facade.ur.vo.UrIntegralSaveRequestVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrIntegralApiService {
    /**
     * 查询ur积分记录
     *
     * @param urIntegralRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urIntegral/getUrIntegralRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<UrIntegralResponseVo>> getUrIntegralRecord(@RequestBody @Valid UrIntegralRequestVo urIntegralRequestVo);

    /**
     *
     * @param urIntegralSaveRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urIntegral/integralAdjust", method = RequestMethod.POST)
    ResponseData<String> integralAdjust(@RequestBody @Valid UrIntegralSaveRequestVo urIntegralSaveRequestVo);

}
