package com.bizvane.members.facade.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * @Author: houkai
 * @Date: 2018/8/8 20:03
 * @Description: 全局业务类型
 */
public enum BusinessTypeEnum {

    INTEGER_PAST_DUE("1", "积分过期"),

    INTEGER_RESERVE("2", "保留原积分"),

    INTEGER_REST("3", "积分清零"),

    INTEGER_ADJUST_EXPEND("4", "手动调整支出"),

    INTEGER_ADJUST_INCOME("5", "手动调整获取"),

    INTEGER_CONSUME_INCOME("6", "商品消费获取"),

    INTEGER_EXCHANGE_EXPEND("7", "积分兑换支出"),

    INTEGER_GAME_EXPEND("8", "游戏消耗支出"),

    ACTIVITY_TYPE_REGISGER("9", "开卡活动"),

    ACTIVITY_TYPE_SMART("10", "智能营销活动"),

    ACTIVITY_TYPE_UPGRADE("11", "升级活动"),

    ACTIVITY_TYPE_QRCODE("12", "扫码领券活动"),

    ACTIVITY_TYPE_MANUAL("13", "手动领券活动"),

    ACTIVITY_TYPE_ORDER("14", "消费活动"),

    ACTIVITY_TYPE_SIGNIN("15", "签到活动"),

    ACTIVITY_TYPE_BIRTHDAY("16", "生日活动"),

    TASK_TYPE_PREFECT("17", "完善资料任务"),

    TASK_TYPE_SHARE("18", "微信分享任务"),

    TASK_TYPE_COMSUMPTION_MONEY("19", "消费金额任务"),

    TASK_TYPE_COMSUMPTION_COUNT("20", "消费次数任务"),

    TASK_TYPE_INVITATION_OPENCARD("21", "邀请开卡任务"),

    TASK_TYPE_MEMORIAL_DAY("22", "纪念日活动"),

    TASK_TYPE_EVALUATE_AWARD("23", "评价奖励活动"),

    OFFLINE_HAND_TYPE("24", "线下手动调整"),

    OFFLINE_ACTIVITY_TYPE("25", "线下活动调整"),

    INTEGRAL_EXCHANGE_COUPON("26", "积分兑换券"),

    SOCIAL_AFFAIR("27", "转盘活动"),

    RED_PACKET_EXPAND_ACTIVIEY("28", "红包膨胀活动"),

    SMASH_EGG_ACTIVITY("29", "砸金蛋活动"),

    INTEGRAL_MALL_CONSUME("30", "积分商城消费积分"),

    INTEGRAL_MALL_RETURN("31", "积分商城返还积分"),

    ACTIVITY_FIRST_ORDER("32", "首单开卡活动"),

    ACTIVITY_BABY_BIRTH("33", "宝宝生日活动"),

    EXCHANGE_OTHER_CONSUME("34", "兑换有赞积分"),

    MICRO_MALL_DECREASE("35", "微商城积分扣减"),

    MICRO_MALL_INCREASE("36", "微商城积分返还"),

    COMPENSATION_INTEGRAL("-1","积分补偿"),

    SHAKE_AND_SHAKE("37","摇一摇"),

    RECHARGE_SEND_GIFT("38","储值送礼");

    private String code;

    private String msg;

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    BusinessTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getBusinessTypeMessage(String code) {
            for (BusinessTypeEnum type : BusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }

    /**
     * 根据枚举code获得枚举
     *
     * @param code
     * @return
     */
    public static BusinessTypeEnum getBusinessTypeEnum(String code) {
        for (BusinessTypeEnum type : BusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    /**
     * 将该枚举全部转化成json
     *
     * @return
     */
    public static JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        for (BusinessTypeEnum e : BusinessTypeEnum.values()) {
            JSONObject object = new JSONObject();
            object.put("typeId", e.getCode());
            object.put("typeName", e.getMsg());
            jsonArray.add(object);
        }
        return jsonArray;
    }
}
