package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.models.qywx.FriendsReportModel;
import com.bizvane.members.facade.models.qywx.IndividualRecruitModel;
import com.bizvane.members.facade.vo.qywx.FriendsReportVo;
import com.bizvane.members.facade.vo.qywx.IndividualRecruitVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.models.qywx.FollowerReportModel;
import com.bizvane.members.facade.models.qywx.MemberReportModel;
import com.bizvane.members.facade.vo.qywx.FollowerReportVo;
import com.bizvane.members.facade.vo.qywx.MemberReportVo;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WxReportApiService {
    @RequestMapping(value = "/api/wxReportApi/getWxFollowerReport", method = RequestMethod.POST)
    FollowerReportModel getWxFollowerReport(@RequestBody FollowerReportVo followerReportVo);

    @RequestMapping(value = "/api/wxReportApi/getMemberReport", method = RequestMethod.POST)
    MemberReportModel getMemberReport(@RequestBody MemberReportVo memberReportVo);

    @RequestMapping(value = "/api/wxReportApi/getFriendsReport", method = RequestMethod.POST)
    FriendsReportModel getFriendsReport(@RequestBody FriendsReportVo friendsReportVo);


    /**
     * 计算导购招募的独立会员/粉丝/好友
     * @return
     */
    @RequestMapping(value = "/api/wxReportApi/calcIndividualRecruit", method = RequestMethod.POST)
    IndividualRecruitModel calcIndividualRecruit(@RequestBody @Valid IndividualRecruitVo individualRecruitVo);

}
