package com.bizvane.members.facade.service.inner;


import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrCompanyWxGroupModel;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.models.MbrGroupTypeModel;
import com.bizvane.members.facade.vo.MbrGroupTypeVo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * 企业微信会员分组设置api
 */

public interface CompanyWxGroupSetService {

    //查询父子级分组名称
    ResponseData<List<MbrGroupTypeVo>> queryAllGroupList(Long brandId) throws MemberException;

    //添加或更新分组
    ResponseData insertOrUpdate(MbrCompanyWxGroupModel mbrCompanyWxGroupModel);

    //中控更新分组类型信息，同步更新企微信息
    void updateCenterGroupValue(MbrGroupModel mbrGroupModel);

    //中控删除分组类型信息
    void removeCenterGroupValue(MbrGroupModel mbrGroupModel);

    //中台更新分组信息，同步更新企微信息
	void updateGroupValue(MbrGroupTypeModel mbrGroupModel);

    //中台更新分组类型信息，同步更新企业微信
	void updateGroupValue(MbrGroupModel mbrGroupModel);

    //中台删除分组类型信息，同步更新企微信息
    void removeGroupValue(MbrGroupTypeModel mbrGroupTypeModel);

    ResponseData queryByBrandId(Long brandId);
}
