package com.bizvane.members.facade.service.qywxapi;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrDefinedGroupModel;
import com.bizvane.members.facade.vo.qywx.MainIndexDefinedGroupRequestVo;
import com.bizvane.members.facade.vo.qywx.MainIndexResponseVo;
import com.bizvane.members.facade.vo.qywx.MbrDefinedGroupInfoRequestVo;
import com.bizvane.members.facade.vo.qywx.MbrDefinedGroupResponseVo;
import com.bizvane.members.facade.vo.qywx.MbrDefinedGroupVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

import javax.validation.Valid;

/**
 * @Author: houkai
 * @Date: 2018/11/26 15:56
 * @Description:
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MbrDefinedGroupApiService {
	/**
	 * 新增自定义分组
	 *
	 * @param mbrDefinedGroupModel
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/definedGroup/saveDefinedGroup", method = RequestMethod.POST)
	ResponseData saveDefinedGroup(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;

	/**
	 * 查询导购所属自定义分组
	 *
	 * @param mbrDefinedGroupModel
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/definedGroup/queryDefinedGroupList", method = RequestMethod.POST)
	ResponseData<List<MbrDefinedGroupModel>> queryDefinedGroupList(
			@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;

	/**
	 * 查询自定义分组详情
	 *
	 * @param mbrDefinedGroupModel
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/definedGroup/queryDefinedGroupInfo", method = RequestMethod.POST)
	@Deprecated
	ResponseData<MbrDefinedGroupVo> queryDefinedGroupInfo(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel)
			throws MemberException;

	/**
	 * 新查询自定义分组详情
	 * 
	 * @param mbrDefinedGroupInfoRequestVo
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/definedGroup/queryDefinedGroupInfoNew", method = RequestMethod.POST)
	ResponseData<MbrDefinedGroupResponseVo> queryDefinedGroupInfoNew(
			@RequestBody MbrDefinedGroupInfoRequestVo mbrDefinedGroupInfoRequestVo) throws MemberException;

	/**
	 * 删除自定义分组
	 *
	 * @param mbrDefinedGroupModel
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/definedGroup/deleteDefinedGroup", method = RequestMethod.POST)
	ResponseData deleteDefinedGroup(@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;

	/**
	 * 获取首页6个自定义分组人群
	 * 
	 * @return
	 * @throws MemberException
	 */
	@RequestMapping(value = "/api/definedGroup/get6MainIndexDefinedGroup", method = RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> get6MainIndexDefinedGroup(
			@RequestBody MbrDefinedGroupModel mbrDefinedGroupModel) throws MemberException;
	
	
	@RequestMapping(value="/api/definedGroup/get6MainIndexDefinedGroupNew",method=RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> get6MainIndexDefinedGroupNew(@RequestBody MainIndexDefinedGroupRequestVo mainIndexDefinedGroupRequestVo)throws MemberException;
	
	
	@RequestMapping(value="/api/definedGroup/getDefinedGroupListNew",method=RequestMethod.POST)
	ResponseData<List<MainIndexResponseVo>> getDefinedGroupListNew(@RequestBody @Valid MainIndexDefinedGroupRequestVo mainIndexDefinedGroupRequestVo)throws MemberException;
}
