package com.bizvane.members.facade.service.taobaoinner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.taobao.AuthCallBackRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberBindQueryRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberBindQueryResponseVo;
import com.bizvane.members.facade.vo.taobao.MemberBindRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberBindResponseVo;
import com.bizvane.members.facade.vo.taobao.MemberQueryRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberQueryResponseVo;
import com.bizvane.members.facade.vo.taobao.MemberRegisterRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberRegisterResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;

public interface MemberBindAndRegisterService {
	/**
	 * 绑定查询请求 tmall.mei.crm.member.bind.query
	 * 
	 * @param memberBindQueryRequestVo
	 * @return
	 */
	ResponseData<MemberBindQueryResponseVo> memberBindQuery(MemberBindQueryRequestVo memberBindQueryRequestVo);

	/**
	 * tmall.mei.crm.bind
	 * 
	 * 当绑定查询返回可绑定时，触发该请求。 当用户解绑时，触发该请求。
	 * 
	 * @param memberBindRequestVo
	 * @return
	 */
	ResponseData<MemberBindResponseVo> memberBind(MemberBindRequestVo memberBindRequestVo);

	/**
	 * tmall.mei.crm.member.register 当绑定查询返回可注册时，会触发该请求。
	 * 
	 * @param memberRegisterRequestVo
	 * @return
	 */
	ResponseData<MemberRegisterResponseVo> memberRegister(MemberRegisterRequestVo memberRegisterRequestVo);

	/**
	 * tmall.mei.crm.query用于查询会员信息，校验会员中心和品牌方会员信息的一致性。
	 * 
	 * @param memberQueryRequestVo
	 * @return
	 */
	ResponseData<MemberQueryResponseVo> memberQuery(MemberQueryRequestVo memberQueryRequestVo);

	/**
	 * 淘宝授权后回调
	 * 
	 * @param authCallBackRequestVo
	 * @return
	 */
	ResponseData<Integer> authCallBack(AuthCallBackRequestVo authCallBackRequestVo);

	/**
	 * 验证开卡过程，开卡门店随机
	 * 
	 * @param memberRegisterRequestVo
	 * @return
	 * @throws Exception
	 */
	ResponseData<MemberRegisterResponseVo> verifyMemberRegister(MemberRegisterRequestVo memberRegisterRequestVo)
			throws MemberException;
}
