package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/13.
 * 会员扩展属性值
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_extend")
public class ExtendPropertyValueModel extends BaseModel implements Serializable {


    private static final long serialVersionUID = -3955954622795264795L;

    @Id
    @ApiModelProperty(value = "属性值id", name = "extendId")
    private Long extendId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "属性code", name = "propertyCode")
    private String propertyCode;

    @ApiModelProperty(value = "属性值", name = "propertyValue")
    private String propertyValue;
}
