package com.bizvane.members.facade.models;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/8/13 09:25
 * @Description: 取数器错误日志
 */
@Data
@NoArgsConstructor
@Table(name="t_mbr_fetch_error_log")
public class FetchErrorLogModel implements Serializable {

    private static final long serialVersionUID = 1268029050238292802L;
    /**
     * 只读.
     * 主键id. mbr_error_log_id
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @Id
    @io.swagger.annotations.ApiModelProperty(value = "主键id", name = "mbrErrorLogId", required = false, example = "主键id")
    private Long mbrErrorLogId;

    /**
     * 只读.
     * 业务场景. business_way
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @io.swagger.annotations.ApiModelProperty(value = "业务场景", name = "businessWay", required = false, example = "业务场景")
    private String businessWay;

    /**
     * 只读.
     * 业务key. business_key
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @io.swagger.annotations.ApiModelProperty(value = "业务key", name = "businessKey", required = false, example = "业务key")
    private String businessKey;

    /**
     * 只读.
     * 消息体. message_body
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @io.swagger.annotations.ApiModelProperty(value = "消息体", name = "messageBody", required = false, example = "消息体")
    private String messageBody;

    /**
     * 只读.
     * 错误类型. error_type
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @io.swagger.annotations.ApiModelProperty(value = "错误类型", name = "errorType", required = false, example = "错误类型")
    private String errorType;

    /**
     * 只读.
     * 空字段. null_field
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @io.swagger.annotations.ApiModelProperty(value = "空字段", name = "nullField", required = false, example = "空字段")
    private String fieldName;

    /**
     * 只读.
     * 错误时间. business_date
     *
     * @mbg.generated 2018-08-13 10:43:15
     */
    @io.swagger.annotations.ApiModelProperty(value = "错误时间", name = "businessDate", required = false, example = "错误时间")
    private Date businessDate;

}
