/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class ApiIntegralChangeServiceAbstract {
    private static final Logger log = LoggerFactory.getLogger(ApiIntegralChangeServiceAbstract.class);

    public abstract void validationData(IntegralChangeRequestModel var1);

    public abstract IntegralChangeResponseModel invokeOfflineChange(IntegralChangeRequestModel var1);

    @Transactional
    protected IntegralChangeResponseModel integralChange(IntegralChangeRequestModel integralChangeRequestModel) {
        this.validationData(integralChangeRequestModel);
        IntegralChangeResponseModel integralChangeResponseModel = this.invokeOfflineChange(integralChangeRequestModel);
        if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode().intValue() && integralChangeResponseModel.getIntegralAdjustId() != null) {
            try {
                integralChangeResponseModel = this.invokeOnlineSyncData(integralChangeRequestModel, integralChangeResponseModel);
                if (SysResponseEnum.SUCCESS.getCode() == integralChangeResponseModel.getCode().intValue()) {
                    this.asyncProcessMessage(integralChangeResponseModel);
                }
                return integralChangeResponseModel;
            }
            catch (MemberException me) {
                log.error(me.getMessage());
                me.getStackTrace();
                integralChangeResponseModel = new IntegralChangeResponseModel();
                integralChangeResponseModel.setCode(SysResponseEnum.FAILED.getCode());
                integralChangeResponseModel.setMessage(me.getMessage());
            }
        }
        log.error("\u7ebf\u4e0b\u64cd\u4f5c\u5931\u8d25\u8fd4\u56de\u4fe1\u606f: " + integralChangeResponseModel.toString());
        return integralChangeResponseModel;
    }

    public abstract IntegralChangeResponseModel invokeOnlineSyncData(IntegralChangeRequestModel var1, IntegralChangeResponseModel var2);

    private void asyncProcessMessage(IntegralChangeResponseModel instance) {
        new Thread(() -> this.notifySendMessage(instance)).start();
    }

    protected abstract void notifySendMessage(IntegralChangeResponseModel var1) throws MemberException;
}

