package com.bizvane.members.facade.service.taobao;

import javax.validation.Valid;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bizvane.members.facade.vo.taobao.AuthCallBackRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberBindQueryRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberBindQueryResponseVo;
import com.bizvane.members.facade.vo.taobao.MemberBindRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberBindResponseVo;
import com.bizvane.members.facade.vo.taobao.MemberQueryRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberQueryResponseVo;
import com.bizvane.members.facade.vo.taobao.MemberRegisterRequestVo;
import com.bizvane.members.facade.vo.taobao.MemberRegisterResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * 会员绑定和注册api
 */
@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberBindAndRegisterApiService {

	/**
	 * 绑定查询请求 tmall.mei.crm.member.bind.query
	 * 
	 * @param memberBindQueryRequestVo
	 * @return
	 */
	@RequestMapping(value = "/api/bindAndRegister/memberBindQuery", method = RequestMethod.POST)
	ResponseData<MemberBindQueryResponseVo> memberBindQuery(
			@RequestBody @Valid MemberBindQueryRequestVo memberBindQueryRequestVo);

	/**
	 * tmall.mei.crm.bind
	 * 
	 * 当绑定查询返回可绑定时，触发该请求。 当用户解绑时，触发该请求。
	 * 
	 * @param memberBindRequestVo
	 * @return
	 */
	@RequestMapping(value = "/api/bindAndRegister/memberBind", method = RequestMethod.POST)
	ResponseData<MemberBindResponseVo> memberBind(@RequestBody @Valid MemberBindRequestVo memberBindRequestVo);

	/**
	 * tmall.mei.crm.member.register 当绑定查询返回可注册时，会触发该请求。
	 * 
	 * @param memberRegisterRequestVo
	 * @return
	 */
	@RequestMapping(value = "/api/bindAndRegister/memberRegister", method = RequestMethod.POST)
	ResponseData<MemberRegisterResponseVo> memberRegister(
			@RequestBody @Valid MemberRegisterRequestVo memberRegisterRequestVo);

	/**
	 * tmall.mei.crm.query用于查询会员信息，校验会员中心和品牌方会员信息的一致性。
	 * 
	 * @param memberQueryRequestVo
	 * @return
	 */
	@RequestMapping(value = "/api/bindAndRegister/memberQuery", method = RequestMethod.POST)
	ResponseData<MemberQueryResponseVo> memberQuery(@RequestBody @Valid MemberQueryRequestVo memberQueryRequestVo);

	/**
	 * 淘宝授权后回调
	 * 
	 * @param authCallBackRequestVo
	 * @return
	 */
	@RequestMapping(value = "/api/bindAndRegister/authCallBack", method = RequestMethod.POST)
	ResponseData<Integer> authCallBack(@RequestBody @Valid AuthCallBackRequestVo authCallBackRequestVo);
}
