package com.bizvane.members.facade.service.card;

import com.bizvane.members.facade.enums.CardStatusEnum;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by Administrator on 2018\8\9 0009.
 */
@Slf4j
public abstract class ApiOpenCardServiceAbstract<P, H> {

	/**
	 * 开卡的主要业务流程
	 * 
	 * @param requestOpenCardModel
	 * @return
	 * @throws MemberException
	 */
	public ResponseOpenCardModel openCardProcess(RequestOpenCardModel requestOpenCardModel) throws MemberException {

		this.validationData(requestOpenCardModel);

		ResponseOpenCardModel responseOpenCardModel = this.invokeOnlineMemberProcess(requestOpenCardModel);

		if (SysResponseEnum.SUCCESS.getCode() == responseOpenCardModel.getCode()) {
			requestOpenCardModel.setIsExist(true);
			if (isBandingCard(responseOpenCardModel)) {
				log.info("线上存在该会员信息，并已开卡");
				return responseOpenCardModel;
			}
			log.info("线上存在该会员信息，但未开卡");
		}
		log.info("线上不存在会员,或者线上会员未绑卡，调用线下登录！");
		
		responseOpenCardModel = this.invokeOfflineLoginProcess(requestOpenCardModel);

		if (resultResponseOpenCard(responseOpenCardModel))
			return responseOpenCardModel;

		log.info("线下不存在,调用线下注册！");

		responseOpenCardModel = this.invokeOfflineRegisterProcess(requestOpenCardModel);

		if (resultResponseOpenCard(responseOpenCardModel))
			return responseOpenCardModel;

		return null;
	}

	private boolean resultResponseOpenCard(ResponseOpenCardModel responseOpenCardModel) {
		if (SysResponseEnum.SUCCESS.getCode() == responseOpenCardModel.getCode()) {
			this.asyncProcessMessage(responseOpenCardModel);
			return true;
		}
		return false;
	}

	private void asyncProcessMessage(ResponseOpenCardModel instance) {
		new Thread(() -> this.notifyActivityTaskAndSendMessage(instance)).start();
	}

	public boolean isBandingCard(ResponseOpenCardModel responseOpenCardModel) {
		if (CardStatusEnum.ALREADY_BIND_CARD.getCode().equals(responseOpenCardModel.getCardStatus())) {
			return true;
		}
		return false;
	}

	// 1.数据验证
	public abstract void validationData(RequestOpenCardModel requestOpenCardModel) throws MemberException;

	// 2.根据手机号判断线上是否存在会员
	// 2.1存在则返回会员信息 包含memberCode、微信头像、微信昵称、会员积分、等级。
	public abstract ResponseOpenCardModel invokeOnlineMemberProcess(RequestOpenCardModel requestOpenCardModel)
			throws MemberException;

	// 2.2不存在则调用线下登录接口,同步响应接口 完善会员信息
	// （1）如果线下存在则更新线上数据，返回响应接口 包含memberCode、微信头像、微信昵称、会员积分、等级。
	public abstract ResponseOpenCardModel invokeOfflineLoginProcess(RequestOpenCardModel requestOpenCardModel)
			throws MemberException;

	// （2）如果线下不存在，则调用注册接口
	// 准备数据 手机号、会员卡体系默认开卡等级code、品牌code 缺少其一则线下开卡失败
	// 注册成功 同步响应信息 完善会员信息
	public abstract ResponseOpenCardModel invokeOfflineRegisterProcess(RequestOpenCardModel requestOpenCardModel)
			throws MemberException;

	// 同步消息和活动任务
	protected abstract void notifyActivityTaskAndSendMessage(ResponseOpenCardModel instance) throws MemberException;

}
