package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

/**
 * @author houkai
 */
public interface MemberSysService {

    /**
     * 新建会员卡体系
     *
     * @param membersSysModel
     * @return
     * @throws MemberException
     */
    ResponseData addMemberSys(MembersSysModel membersSysModel) throws MemberException;

    /**
     * 根据品牌查询会员卡体系详情
     *
     * @param brandId
     * @return
     */
    ResponseData<MembersSysModel> queryMemberSysInfo(long brandId);

    /**
     * 编辑会员卡体系
     *
     * @param membersSysModel
     * @return
     * @throws MemberException
     */
    ResponseData updateMemberSys(MembersSysModel membersSysModel) throws MemberException;

    /**
     * 根据会员信息生成会员卡号
     *
     * @param memberInfoModel
     * @return
     */
    String produceCarNo(MemberInfoModel memberInfoModel);

    /**
     * 保存会员卡体系
     *
     * @param membersSysModel
     * @param currentUser
     * @return
     */
    ResponseData saveMemberSys(MembersSysModel membersSysModel, SysAccountPO currentUser);
}
