package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/7/16 15:45
 * @Description: 会员消费行为
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_consume_behavior")
public class MbrConsumeBehaviorModel extends BaseModel {

    private static final long serialVersionUID = 1940216398401070802L;

    /**
     * 只读.
     * 主键id. mbr_consume_behavior_id
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "主键id", name = "mbrConsumeBehaviorId", required = false, example = "主键id")
    private Long mbrConsumeBehaviorId;

    /**
     * 只读.
     * 企业id. sys_company_id
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "企业id", name = "sysCompanyId", required = false, example = "企业id")
    private Long sysCompanyId;


    /**
     * 只读.
     * 企业id. brand_id
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "品牌id", name = "brandId", required = false, example = "品牌id")
    private Long brandId;

    /**
     * 只读.
     * 会员code. member_code
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "会员code", name = "memberCode", required = false, example = "会员code")
    private String memberCode;

    /**
     * 只读.
     * 消费折扣. consume_discount
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费折扣", name = "consumeDiscount", required = false, example = "消费折扣")
    private Integer consumeDiscount;

    /**
     * 只读.
     * 消费件数. consume_number
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费件数", name = "consumeNumber", required = false, example = "消费件数")
    private Integer consumeNumber;

    /**
     * 只读.
     * 单笔最高. highest_number
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "单笔最高", name = "highestNumber", required = false, example = "单笔最高")
    private BigDecimal highestNumber;

    /**
     * 只读.
     * 消费渠道占比. consume_channel_rate
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费渠道占比", name = "consumeChannelRate", required = false, example = "消费渠道占比")
    private String consumeChannelRate;

    /**
     * 只读.
     * 件单价. price
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "件单价", name = "price", required = false, example = "件单价")
    private BigDecimal price;

    /**
     * 只读.
     * 是否为新会员: 1=新会员; 2=老会员. group_new_member
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "是否为新会员: 1=新会员; 2=老会员", name = "groupNewMember", required = false, example = "是否为新会员: 1=新会员; 2=老会员")
    private Integer groupNewMember;

    /**
     * 只读.
     * 会员活跃度: 1=活跃会员; 2=沉默会员; 3=濒临睡眠会员; 4=休眠会员; 5=流失会员;. member_liveness
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "会员活跃度: 1=活跃会员; 2=沉默会员; 3=濒临睡眠会员; 4=休眠会员; 5=流失会员;", name = "memberLiveness", required = false, example = "会员活跃度: 1=活跃会员; 2=沉默会员; 3=濒临睡眠会员; 4=休眠会员; 5=流失会员;")
    private Integer memberLiveness;

    /**
     * 只读.
     * 消费金额累计. consume_amount_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额累计", name = "consumeAmountAll", required = false, example = "消费金额累计")
    private BigDecimal consumeAmountAll;

    /**
     * 只读.
     * 消费金额最近1个月. consume_amount_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近1个月", name = "consumeAmount1", required = false, example = "消费金额最近1个月")
    private BigDecimal consumeAmount1;

    /**
     * 只读.
     * 消费金额最近2个月. consume_amount_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近2个月", name = "consumeAmount2", required = false, example = "消费金额最近2个月")
    private BigDecimal consumeAmount2;

    /**
     * 只读.
     * 消费金额最近3个月. consume_amount_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近3个月", name = "consumeAmount3", required = false, example = "消费金额最近3个月")
    private BigDecimal consumeAmount3;

    /**
     * 只读.
     * 消费金额最近4个月. consume_amount_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近4个月", name = "consumeAmount4", required = false, example = "消费金额最近4个月")
    private BigDecimal consumeAmount4;

    /**
     * 只读.
     * 消费金额最近5个月. consume_amount_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近5个月", name = "consumeAmount5", required = false, example = "消费金额最近5个月")
    private BigDecimal consumeAmount5;

    /**
     * 只读.
     * 消费金额最近6个月. consume_amount_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近6个月", name = "consumeAmount6", required = false, example = "消费金额最近6个月")
    private BigDecimal consumeAmount6;

    /**
     * 只读.
     * 消费金额最近7个月. consume_amount_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近7个月", name = "consumeAmount7", required = false, example = "消费金额最近7个月")
    private BigDecimal consumeAmount7;

    /**
     * 只读.
     * 消费金额最近8个月. consume_amount_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近8个月", name = "consumeAmount8", required = false, example = "消费金额最近8个月")
    private BigDecimal consumeAmount8;

    /**
     * 只读.
     * 消费金额最近9个月. consume_amount_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近9个月", name = "consumeAmount9", required = false, example = "消费金额最近9个月")
    private BigDecimal consumeAmount9;

    /**
     * 只读.
     * 消费金额最近10个月. consume_amount_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近10个月", name = "consumeAmount10", required = false, example = "消费金额最近10个月")
    private BigDecimal consumeAmount10;

    /**
     * 只读.
     * 消费金额最近11个月. consume_amount_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近11个月", name = "consumeAmount11", required = false, example = "消费金额最近11个月")
    private BigDecimal consumeAmount11;

    /**
     * 只读.
     * 消费金额最近12个月. consume_amount_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近12个月", name = "consumeAmount12", required = false, example = "消费金额最近12个月")
    private BigDecimal consumeAmount12;

    /**
     * 只读.
     * 消费金额最近13个月. consume_amount_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近13个月", name = "consumeAmount13", required = false, example = "消费金额最近13个月")
    private BigDecimal consumeAmount13;

    /**
     * 只读.
     * 消费金额最近14个月. consume_amount_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近14个月", name = "consumeAmount14", required = false, example = "消费金额最近14个月")
    private BigDecimal consumeAmount14;

    /**
     * 只读.
     * 消费金额最近15个月. consume_amount_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近15个月", name = "consumeAmount15", required = false, example = "消费金额最近15个月")
    private BigDecimal consumeAmount15;

    /**
     * 只读.
     * 消费金额最近16个月. consume_amount_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近16个月", name = "consumeAmount16", required = false, example = "消费金额最近16个月")
    private BigDecimal consumeAmount16;

    /**
     * 只读.
     * 消费金额最近17个月. consume_amount_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近17个月", name = "consumeAmount17", required = false, example = "消费金额最近17个月")
    private BigDecimal consumeAmount17;

    /**
     * 只读.
     * 消费金额最近18个月. consume_amount_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近18个月", name = "consumeAmount18", required = false, example = "消费金额最近18个月")
    private BigDecimal consumeAmount18;

    /**
     * 只读.
     * 消费金额最近19个月. consume_amount_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近19个月", name = "consumeAmount19", required = false, example = "消费金额最近19个月")
    private BigDecimal consumeAmount19;

    /**
     * 只读.
     * 消费金额最近20个月. consume_amount_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近20个月", name = "consumeAmount20", required = false, example = "消费金额最近20个月")
    private BigDecimal consumeAmount20;

    /**
     * 只读.
     * 消费金额最近21个月. consume_amount_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近21个月", name = "consumeAmount21", required = false, example = "消费金额最近21个月")
    private BigDecimal consumeAmount21;

    /**
     * 只读.
     * 消费金额最近22个月. consume_amount_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近22个月", name = "consumeAmount22", required = false, example = "消费金额最近22个月")
    private BigDecimal consumeAmount22;

    /**
     * 只读.
     * 消费金额最近23个月. consume_amount_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近23个月", name = "consumeAmount23", required = false, example = "消费金额最近23个月")
    private BigDecimal consumeAmount23;

    /**
     * 只读.
     * 消费金额最近24个月. consume_amount_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费金额最近24个月", name = "consumeAmount24", required = false, example = "消费金额最近24个月")
    private BigDecimal consumeAmount24;

    /**
     * 只读.
     * 消费次数累计. consume_number_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数累计", name = "consumeNumberAll", required = false, example = "消费次数累计")
    private Integer consumeNumberAll;

    /**
     * 只读.
     * 消费次数1个月. consume_number_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数1个月", name = "consumeNumber1", required = false, example = "消费次数1个月")
    private Integer consumeNumber1;

    /**
     * 只读.
     * 消费次数2个月. consume_number_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数2个月", name = "consumeNumber2", required = false, example = "消费次数2个月")
    private Integer consumeNumber2;

    /**
     * 只读.
     * 消费次数3个月. consume_number_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数3个月", name = "consumeNumber3", required = false, example = "消费次数3个月")
    private Integer consumeNumber3;

    /**
     * 只读.
     * 消费次数4个月. consume_number_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数4个月", name = "consumeNumber4", required = false, example = "消费次数4个月")
    private Integer consumeNumber4;

    /**
     * 只读.
     * 消费次数5个月. consume_number_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数5个月", name = "consumeNumber5", required = false, example = "消费次数5个月")
    private Integer consumeNumber5;

    /**
     * 只读.
     * 消费次数6个月. consume_number_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数6个月", name = "consumeNumber6", required = false, example = "消费次数6个月")
    private Integer consumeNumber6;

    /**
     * 只读.
     * 消费次数7个月. consume_number_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数7个月", name = "consumeNumber7", required = false, example = "消费次数7个月")
    private Integer consumeNumber7;

    /**
     * 只读.
     * 消费次数8个月. consume_number_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数8个月", name = "consumeNumber8", required = false, example = "消费次数8个月")
    private Integer consumeNumber8;

    /**
     * 只读.
     * 消费次数9个月. consume_number_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数9个月", name = "consumeNumber9", required = false, example = "消费次数9个月")
    private Integer consumeNumber9;

    /**
     * 只读.
     * 消费次数10个月. consume_number_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数10个月", name = "consumeNumber10", required = false, example = "消费次数10个月")
    private Integer consumeNumber10;

    /**
     * 只读.
     * 消费次数11个月. consume_number_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数11个月", name = "consumeNumber11", required = false, example = "消费次数11个月")
    private Integer consumeNumber11;

    /**
     * 只读.
     * 消费次数12个月. consume_number_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数12个月", name = "consumeNumber12", required = false, example = "消费次数12个月")
    private Integer consumeNumber12;

    /**
     * 只读.
     * 消费次数13个月. consume_number_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数13个月", name = "consumeNumber13", required = false, example = "消费次数13个月")
    private Integer consumeNumber13;

    /**
     * 只读.
     * 消费次数14个月. consume_number_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数14个月", name = "consumeNumber14", required = false, example = "消费次数14个月")
    private Integer consumeNumber14;

    /**
     * 只读.
     * 消费次数15个月. consume_number_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数15个月", name = "consumeNumber15", required = false, example = "消费次数15个月")
    private Integer consumeNumber15;

    /**
     * 只读.
     * 消费次数16个月. consume_number_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数16个月", name = "consumeNumber16", required = false, example = "消费次数16个月")
    private Integer consumeNumber16;

    /**
     * 只读.
     * 消费次数17个月. consume_number_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数17个月", name = "consumeNumber17", required = false, example = "消费次数17个月")
    private Integer consumeNumber17;

    /**
     * 只读.
     * 消费次数18个月. consume_number_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数18个月", name = "consumeNumber18", required = false, example = "消费次数18个月")
    private Integer consumeNumber18;

    /**
     * 只读.
     * 消费次数19个月. consume_number_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数19个月", name = "consumeNumber19", required = false, example = "消费次数19个月")
    private Integer consumeNumber19;

    /**
     * 只读.
     * 消费次数20个月. consume_number_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数20个月", name = "consumeNumber20", required = false, example = "消费次数20个月")
    private Integer consumeNumber20;

    /**
     * 只读.
     * 消费次数21个月. consume_number_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数21个月", name = "consumeNumber21", required = false, example = "消费次数21个月")
    private Integer consumeNumber21;

    /**
     * 只读.
     * 消费次数22个月. consume_number_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数22个月", name = "consumeNumber22", required = false, example = "消费次数22个月")
    private Integer consumeNumber22;

    /**
     * 只读.
     * 消费次数23个月. consume_number_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数23个月", name = "consumeNumber23", required = false, example = "消费次数23个月")
    private Integer consumeNumber23;

    /**
     * 只读.
     * 消费次数24个月. consume_number_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消费次数24个月", name = "consumeNumber24", required = false, example = "消费次数24个月")
    private Integer consumeNumber24;

    /**
     * 只读.
     * 退款金额累计. refund_amount_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额累计", name = "refundAmountAll", required = false, example = "退款金额累计")
    private BigDecimal refundAmountAll;

    /**
     * 只读.
     * 退款金额1个月. refund_amount_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额1个月", name = "refundAmount1", required = false, example = "退款金额1个月")
    private BigDecimal refundAmount1;

    /**
     * 只读.
     * 退款金额2个月. refund_amount_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额2个月", name = "refundAmount2", required = false, example = "退款金额2个月")
    private BigDecimal refundAmount2;

    /**
     * 只读.
     * 退款金额3个月. refund_amount_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额3个月", name = "refundAmount3", required = false, example = "退款金额3个月")
    private BigDecimal refundAmount3;

    /**
     * 只读.
     * 退款金额4个月. refund_amount_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额4个月", name = "refundAmount4", required = false, example = "退款金额4个月")
    private BigDecimal refundAmount4;

    /**
     * 只读.
     * 退款金额5个月. refund_amount_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额5个月", name = "refundAmount5", required = false, example = "退款金额5个月")
    private BigDecimal refundAmount5;

    /**
     * 只读.
     * 退款金额6个月. refund_amount_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额6个月", name = "refundAmount6", required = false, example = "退款金额6个月")
    private BigDecimal refundAmount6;

    /**
     * 只读.
     * 退款金额7个月. refund_amount_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额7个月", name = "refundAmount7", required = false, example = "退款金额7个月")
    private BigDecimal refundAmount7;

    /**
     * 只读.
     * 退款金额8个月. refund_amount_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额8个月", name = "refundAmount8", required = false, example = "退款金额8个月")
    private BigDecimal refundAmount8;

    /**
     * 只读.
     * 退款金额9个月. refund_amount_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额9个月", name = "refundAmount9", required = false, example = "退款金额9个月")
    private BigDecimal refundAmount9;

    /**
     * 只读.
     * 退款金额10个月. refund_amount_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额10个月", name = "refundAmount10", required = false, example = "退款金额10个月")
    private BigDecimal refundAmount10;

    /**
     * 只读.
     * 退款金额11个月. refund_amount_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额11个月", name = "refundAmount11", required = false, example = "退款金额11个月")
    private BigDecimal refundAmount11;

    /**
     * 只读.
     * 退款金额12个月. refund_amount_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额12个月", name = "refundAmount12", required = false, example = "退款金额12个月")
    private BigDecimal refundAmount12;

    /**
     * 只读.
     * 退款金额13个月. refund_amount_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额13个月", name = "refundAmount13", required = false, example = "退款金额13个月")
    private BigDecimal refundAmount13;

    /**
     * 只读.
     * 退款金额14个月. refund_amount_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额14个月", name = "refundAmount14", required = false, example = "退款金额14个月")
    private BigDecimal refundAmount14;

    /**
     * 只读.
     * 退款金额15个月. refund_amount_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额15个月", name = "refundAmount15", required = false, example = "退款金额15个月")
    private BigDecimal refundAmount15;

    /**
     * 只读.
     * 退款金额16个月. refund_amount_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额16个月", name = "refundAmount16", required = false, example = "退款金额16个月")
    private BigDecimal refundAmount16;

    /**
     * 只读.
     * 退款金额17个月. refund_amount_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额17个月", name = "refundAmount17", required = false, example = "退款金额17个月")
    private BigDecimal refundAmount17;

    /**
     * 只读.
     * 退款金额18个月. refund_amount_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额18个月", name = "refundAmount18", required = false, example = "退款金额18个月")
    private BigDecimal refundAmount18;

    /**
     * 只读.
     * 退款金额19个月. refund_amount_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额19个月", name = "refundAmount19", required = false, example = "退款金额19个月")
    private BigDecimal refundAmount19;

    /**
     * 只读.
     * 退款金额20个月. refund_amount_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额20个月", name = "refundAmount20", required = false, example = "退款金额20个月")
    private BigDecimal refundAmount20;

    /**
     * 只读.
     * 退款金额21个月. refund_amount_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额21个月", name = "refundAmount21", required = false, example = "退款金额21个月")
    private BigDecimal refundAmount21;

    /**
     * 只读.
     * 退款金额22个月. refund_amount_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额22个月", name = "refundAmount22", required = false, example = "退款金额22个月")
    private BigDecimal refundAmount22;

    /**
     * 只读.
     * 退款金额23个月. refund_amount_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额23个月", name = "refundAmount23", required = false, example = "退款金额23个月")
    private BigDecimal refundAmount23;

    /**
     * 只读.
     * 退款金额24个月. refund_amount_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款金额24个月", name = "refundAmount24", required = false, example = "退款金额24个月")
    private BigDecimal refundAmount24;

    /**
     * 只读.
     * 退款次数累计. refund_number_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数累计", name = "refundNumberAll", required = false, example = "退款次数累计")
    private Integer refundNumberAll;

    /**
     * 只读.
     * 退款次数1个月. refund_number_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数1个月", name = "refundNumber1", required = false, example = "退款次数1个月")
    private Integer refundNumber1;

    /**
     * 只读.
     * 退款次数2个月. refund_number_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数2个月", name = "refundNumber2", required = false, example = "退款次数2个月")
    private Integer refundNumber2;

    /**
     * 只读.
     * 退款次数3个月. refund_number_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数3个月", name = "refundNumber3", required = false, example = "退款次数3个月")
    private Integer refundNumber3;

    /**
     * 只读.
     * 退款次数4个月. refund_number_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数4个月", name = "refundNumber4", required = false, example = "退款次数4个月")
    private Integer refundNumber4;

    /**
     * 只读.
     * 退款次数5个月. refund_number_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数5个月", name = "refundNumber5", required = false, example = "退款次数5个月")
    private Integer refundNumber5;

    /**
     * 只读.
     * 退款次数6个月. refund_number_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数6个月", name = "refundNumber6", required = false, example = "退款次数6个月")
    private Integer refundNumber6;

    /**
     * 只读.
     * 退款次数7个月. refund_number_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数7个月", name = "refundNumber7", required = false, example = "退款次数7个月")
    private Integer refundNumber7;

    /**
     * 只读.
     * 退款次数8个月. refund_number_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数8个月", name = "refundNumber8", required = false, example = "退款次数8个月")
    private Integer refundNumber8;

    /**
     * 只读.
     * 退款次数9个月. refund_number_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数9个月", name = "refundNumber9", required = false, example = "退款次数9个月")
    private Integer refundNumber9;

    /**
     * 只读.
     * 退款次数10个月. refund_number_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数10个月", name = "refundNumber10", required = false, example = "退款次数10个月")
    private Integer refundNumber10;

    /**
     * 只读.
     * 退款次数11个月. refund_number_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数11个月", name = "refundNumber11", required = false, example = "退款次数11个月")
    private Integer refundNumber11;

    /**
     * 只读.
     * 退款次数12个月. refund_number_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数12个月", name = "refundNumber12", required = false, example = "退款次数12个月")
    private Integer refundNumber12;

    /**
     * 只读.
     * 退款次数13个月. refund_number_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数13个月", name = "refundNumber13", required = false, example = "退款次数13个月")
    private Integer refundNumber13;

    /**
     * 只读.
     * 退款次数14个月. refund_number_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数14个月", name = "refundNumber14", required = false, example = "退款次数14个月")
    private Integer refundNumber14;

    /**
     * 只读.
     * 退款次数15个月. refund_number_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数15个月", name = "refundNumber15", required = false, example = "退款次数15个月")
    private Integer refundNumber15;

    /**
     * 只读.
     * 退款次数16个月. refund_number_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数16个月", name = "refundNumber16", required = false, example = "退款次数16个月")
    private Integer refundNumber16;

    /**
     * 只读.
     * 退款次数17个月. refund_number_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数17个月", name = "refundNumber17", required = false, example = "退款次数17个月")
    private Integer refundNumber17;

    /**
     * 只读.
     * 退款次数18个月. refund_number_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数18个月", name = "refundNumber18", required = false, example = "退款次数18个月")
    private Integer refundNumber18;

    /**
     * 只读.
     * 退款次数19个月. refund_number_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数19个月", name = "refundNumber19", required = false, example = "退款次数19个月")
    private Integer refundNumber19;

    /**
     * 只读.
     * 退款次数20个月. refund_number_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数20个月", name = "refundNumber20", required = false, example = "退款次数20个月")
    private Integer refundNumber20;

    /**
     * 只读.
     * 退款次数21个月. refund_number_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数21个月", name = "refundNumber21", required = false, example = "退款次数21个月")
    private Integer refundNumber21;

    /**
     * 只读.
     * 退款次数22个月. refund_number_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数22个月", name = "refundNumber22", required = false, example = "退款次数22个月")
    private Integer refundNumber22;

    /**
     * 只读.
     * 退款次数23个月. refund_number_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数23个月", name = "refundNumber23", required = false, example = "退款次数23个月")
    private Integer refundNumber23;

    /**
     * 只读.
     * 退款次数24个月. refund_number_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "退款次数24个月", name = "refundNumber24", required = false, example = "退款次数24个月")
    private Integer refundNumber24;

    /**
     * 只读.
     * 客单价金额累计. pct_amount_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额累计", name = "pctAmountAll", required = false, example = "客单价金额累计")
    private BigDecimal pctAmountAll;

    /**
     * 只读.
     * 客单价金额1个月. pct_amount_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额1个月", name = "pctAmount1", required = false, example = "客单价金额1个月")
    private BigDecimal pctAmount1;

    /**
     * 只读.
     * 客单价金额2个月. pct_amount_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额2个月", name = "pctAmount2", required = false, example = "客单价金额2个月")
    private BigDecimal pctAmount2;

    /**
     * 只读.
     * 客单价金额3个月. pct_amount_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额3个月", name = "pctAmount3", required = false, example = "客单价金额3个月")
    private BigDecimal pctAmount3;

    /**
     * 只读.
     * 客单价金额4个月. pct_amount_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额4个月", name = "pctAmount4", required = false, example = "客单价金额4个月")
    private BigDecimal pctAmount4;

    /**
     * 只读.
     * 客单价金额5个月. pct_amount_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额5个月", name = "pctAmount5", required = false, example = "客单价金额5个月")
    private BigDecimal pctAmount5;

    /**
     * 只读.
     * 客单价金额6个月. pct_amount_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额6个月", name = "pctAmount6", required = false, example = "客单价金额6个月")
    private BigDecimal pctAmount6;

    /**
     * 只读.
     * 客单价金额7个月. pct_amount_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额7个月", name = "pctAmount7", required = false, example = "客单价金额7个月")
    private BigDecimal pctAmount7;

    /**
     * 只读.
     * 客单价金额8个月. pct_amount_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额8个月", name = "pctAmount8", required = false, example = "客单价金额8个月")
    private BigDecimal pctAmount8;

    /**
     * 只读.
     * 客单价金额9个月. pct_amount_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额9个月", name = "pctAmount9", required = false, example = "客单价金额9个月")
    private BigDecimal pctAmount9;

    /**
     * 只读.
     * 客单价金额10个月. pct_amount_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额10个月", name = "pctAmount10", required = false, example = "客单价金额10个月")
    private BigDecimal pctAmount10;

    /**
     * 只读.
     * 客单价金额11个月. pct_amount_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额11个月", name = "pctAmount11", required = false, example = "客单价金额11个月")
    private BigDecimal pctAmount11;

    /**
     * 只读.
     * 客单价金额12个月. pct_amount_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额12个月", name = "pctAmount12", required = false, example = "客单价金额12个月")
    private BigDecimal pctAmount12;

    /**
     * 只读.
     * 客单价金额13个月. pct_amount_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额13个月", name = "pctAmount13", required = false, example = "客单价金额13个月")
    private BigDecimal pctAmount13;

    /**
     * 只读.
     * 客单价金额14个月. pct_amount_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额14个月", name = "pctAmount14", required = false, example = "客单价金额14个月")
    private BigDecimal pctAmount14;

    /**
     * 只读.
     * 客单价金额15个月. pct_amount_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额15个月", name = "pctAmount15", required = false, example = "客单价金额15个月")
    private BigDecimal pctAmount15;

    /**
     * 只读.
     * 客单价金额16个月. pct_amount_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额16个月", name = "pctAmount16", required = false, example = "客单价金额16个月")
    private BigDecimal pctAmount16;

    /**
     * 只读.
     * 客单价金额17个月. pct_amount_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额17个月", name = "pctAmount17", required = false, example = "客单价金额17个月")
    private BigDecimal pctAmount17;

    /**
     * 只读.
     * 客单价金额18个月. pct_amount_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额18个月", name = "pctAmount18", required = false, example = "客单价金额18个月")
    private BigDecimal pctAmount18;

    /**
     * 只读.
     * 客单价金额19个月. pct_amount_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额19个月", name = "pctAmount19", required = false, example = "客单价金额19个月")
    private BigDecimal pctAmount19;

    /**
     * 只读.
     * 客单价金额20个月. pct_amount_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额20个月", name = "pctAmount20", required = false, example = "客单价金额20个月")
    private BigDecimal pctAmount20;

    /**
     * 只读.
     * 客单价金额21个月. pct_amount_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额21个月", name = "pctAmount21", required = false, example = "客单价金额21个月")
    private BigDecimal pctAmount21;

    /**
     * 只读.
     * 客单价金额22个月. pct_amount_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额22个月", name = "pctAmount22", required = false, example = "客单价金额22个月")
    private BigDecimal pctAmount22;

    /**
     * 只读.
     * 客单价金额23个月. pct_amount_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额23个月", name = "pctAmount23", required = false, example = "客单价金额23个月")
    private BigDecimal pctAmount23;

    /**
     * 只读.
     * 客单价金额24个月. pct_amount_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "客单价金额24个月", name = "pctAmount24", required = false, example = "客单价金额24个月")
    private BigDecimal pctAmount24;

    /**
     * 只读.
     * 折扣率累计. discount_rate_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率累计", name = "discountRateAll", required = false, example = "折扣率累计")
    private Integer discountRateAll;

    /**
     * 只读.
     * 折扣率1个月. discount_rate_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率1个月", name = "discountRate1", required = false, example = "折扣率1个月")
    private Integer discountRate1;

    /**
     * 只读.
     * 折扣率2个月. discount_rate_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率2个月", name = "discountRate2", required = false, example = "折扣率2个月")
    private Integer discountRate2;

    /**
     * 只读.
     * 折扣率3个月. discount_rate_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率3个月", name = "discountRate3", required = false, example = "折扣率3个月")
    private Integer discountRate3;

    /**
     * 只读.
     * 折扣率4个月. discount_rate_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率4个月", name = "discountRate4", required = false, example = "折扣率4个月")
    private Integer discountRate4;

    /**
     * 只读.
     * 折扣率5个月. discount_rate_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率5个月", name = "discountRate5", required = false, example = "折扣率5个月")
    private Integer discountRate5;

    /**
     * 只读.
     * 折扣率6个月. discount_rate_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率6个月", name = "discountRate6", required = false, example = "折扣率6个月")
    private Integer discountRate6;

    /**
     * 只读.
     * 折扣率7个月. discount_rate_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率7个月", name = "discountRate7", required = false, example = "折扣率7个月")
    private Integer discountRate7;

    /**
     * 只读.
     * 折扣率8个月. discount_rate_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率8个月", name = "discountRate8", required = false, example = "折扣率8个月")
    private Integer discountRate8;

    /**
     * 只读.
     * 折扣率9个月. discount_rate_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率9个月", name = "discountRate9", required = false, example = "折扣率9个月")
    private Integer discountRate9;

    /**
     * 只读.
     * 折扣率10个月. discount_rate_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率10个月", name = "discountRate10", required = false, example = "折扣率10个月")
    private Integer discountRate10;

    /**
     * 只读.
     * 折扣率11个月. discount_rate_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率11个月", name = "discountRate11", required = false, example = "折扣率11个月")
    private Integer discountRate11;

    /**
     * 只读.
     * 折扣率12个月. discount_rate_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率12个月", name = "discountRate12", required = false, example = "折扣率12个月")
    private Integer discountRate12;

    /**
     * 只读.
     * 折扣率13个月. discount_rate_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率13个月", name = "discountRate13", required = false, example = "折扣率13个月")
    private Integer discountRate13;

    /**
     * 只读.
     * 折扣率14个月. discount_rate_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率14个月", name = "discountRate14", required = false, example = "折扣率14个月")
    private Integer discountRate14;

    /**
     * 只读.
     * 折扣率15个月. discount_rate_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率15个月", name = "discountRate15", required = false, example = "折扣率15个月")
    private Integer discountRate15;

    /**
     * 只读.
     * 折扣率16个月. discount_rate_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率16个月", name = "discountRate16", required = false, example = "折扣率16个月")
    private Integer discountRate16;

    /**
     * 只读.
     * 折扣率17个月. discount_rate_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率17个月", name = "discountRate17", required = false, example = "折扣率17个月")
    private Integer discountRate17;

    /**
     * 只读.
     * 折扣率18个月. discount_rate_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率18个月", name = "discountRate18", required = false, example = "折扣率18个月")
    private Integer discountRate18;

    /**
     * 只读.
     * 折扣率19个月. discount_rate_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率19个月", name = "discountRate19", required = false, example = "折扣率19个月")
    private Integer discountRate19;

    /**
     * 只读.
     * 折扣率20个月. discount_rate_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率20个月", name = "discountRate20", required = false, example = "折扣率20个月")
    private Integer discountRate20;

    /**
     * 只读.
     * 折扣率21个月. discount_rate_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率21个月", name = "discountRate21", required = false, example = "折扣率21个月")
    private Integer discountRate21;

    /**
     * 只读.
     * 折扣率22个月. discount_rate_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率22个月", name = "discountRate22", required = false, example = "折扣率22个月")
    private Integer discountRate22;

    /**
     * 只读.
     * 折扣率23个月. discount_rate_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率23个月", name = "discountRate23", required = false, example = "折扣率23个月")
    private Integer discountRate23;

    /**
     * 只读.
     * 折扣率24个月. discount_rate_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "折扣率24个月", name = "discountRate24", required = false, example = "折扣率24个月")
    private Integer discountRate24;

    /**
     * 只读.
     * 连带率件数累计. apr_number_all
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数累计", name = "aprNumberAll", required = false, example = "连带率件数累计")
    private BigDecimal aprNumberAll;

    /**
     * 只读.
     * 连带率件数1个月. apr_number_1
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数1个月", name = "aprNumber1", required = false, example = "连带率件数1个月")
    private BigDecimal aprNumber1;

    /**
     * 只读.
     * 连带率件数2个月. apr_number_2
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数2个月", name = "aprNumber2", required = false, example = "连带率件数2个月")
    private BigDecimal aprNumber2;

    /**
     * 只读.
     * 连带率件数3个月. apr_number_3
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数3个月", name = "aprNumber3", required = false, example = "连带率件数3个月")
    private BigDecimal aprNumber3;

    /**
     * 只读.
     * 连带率件数4个月. apr_number_4
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数4个月", name = "aprNumber4", required = false, example = "连带率件数4个月")
    private BigDecimal aprNumber4;

    /**
     * 只读.
     * 连带率件数5个月. apr_number_5
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数5个月", name = "aprNumber5", required = false, example = "连带率件数5个月")
    private BigDecimal aprNumber5;

    /**
     * 只读.
     * 连带率件数6个月. apr_number_6
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数6个月", name = "aprNumber6", required = false, example = "连带率件数6个月")
    private BigDecimal aprNumber6;

    /**
     * 只读.
     * 连带率件数7个月. apr_number_7
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数7个月", name = "aprNumber7", required = false, example = "连带率件数7个月")
    private BigDecimal aprNumber7;

    /**
     * 只读.
     * 连带率件数8个月. apr_number_8
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数8个月", name = "aprNumber8", required = false, example = "连带率件数8个月")
    private BigDecimal aprNumber8;

    /**
     * 只读.
     * 连带率件数9个月. apr_number_9
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数9个月", name = "aprNumber9", required = false, example = "连带率件数9个月")
    private BigDecimal aprNumber9;

    /**
     * 只读.
     * 连带率件数10个月. apr_number_10
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数10个月", name = "aprNumber10", required = false, example = "连带率件数10个月")
    private BigDecimal aprNumber10;

    /**
     * 只读.
     * 连带率件数11个月. apr_number_11
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数11个月", name = "aprNumber11", required = false, example = "连带率件数11个月")
    private BigDecimal aprNumber11;

    /**
     * 只读.
     * 连带率件数12个月. apr_number_12
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数12个月", name = "aprNumber12", required = false, example = "连带率件数12个月")
    private BigDecimal aprNumber12;

    /**
     * 只读.
     * 连带率件数13个月. apr_number_13
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数13个月", name = "aprNumber13", required = false, example = "连带率件数13个月")
    private BigDecimal aprNumber13;

    /**
     * 只读.
     * 连带率件数14个月. apr_number_14
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数14个月", name = "aprNumber14", required = false, example = "连带率件数14个月")
    private BigDecimal aprNumber14;

    /**
     * 只读.
     * 连带率件数15个月. apr_number_15
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数15个月", name = "aprNumber15", required = false, example = "连带率件数15个月")
    private BigDecimal aprNumber15;

    /**
     * 只读.
     * 连带率件数16个月. apr_number_16
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数16个月", name = "aprNumber16", required = false, example = "连带率件数16个月")
    private BigDecimal aprNumber16;

    /**
     * 只读.
     * 连带率件数17个月. apr_number_17
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数17个月", name = "aprNumber17", required = false, example = "连带率件数17个月")
    private BigDecimal aprNumber17;

    /**
     * 只读.
     * 连带率件数18个月. apr_number_18
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数18个月", name = "aprNumber18", required = false, example = "连带率件数18个月")
    private BigDecimal aprNumber18;

    /**
     * 只读.
     * 连带率件数19个月. apr_number_19
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数19个月", name = "aprNumber19", required = false, example = "连带率件数19个月")
    private BigDecimal aprNumber19;

    /**
     * 只读.
     * 连带率件数20个月. apr_number_20
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数20个月", name = "aprNumber20", required = false, example = "连带率件数20个月")
    private BigDecimal aprNumber20;

    /**
     * 只读.
     * 连带率件数21个月. apr_number_21
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数21个月", name = "aprNumber21", required = false, example = "连带率件数21个月")
    private BigDecimal aprNumber21;

    /**
     * 只读.
     * 连带率件数22个月. apr_number_22
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数22个月", name = "aprNumber22", required = false, example = "连带率件数22个月")
    private BigDecimal aprNumber22;

    /**
     * 只读.
     * 连带率件数23个月. apr_number_23
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数23个月", name = "aprNumber23", required = false, example = "连带率件数23个月")
    private BigDecimal aprNumber23;

    /**
     * 只读.
     * 连带率件数24个月. apr_number_24
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "连带率件数24个月", name = "aprNumber24", required = false, example = "连带率件数24个月")
    private BigDecimal aprNumber24;

    /**
     * 只读.
     * 券总数. coupon_total_number
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "券总数", name = "couponTotalNumber", required = false, example = "券总数")
    private Integer couponTotalNumber;

    /**
     * 只读.
     * 券已使用数. coupon_use_number
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "券已使用数", name = "couponUseNumber", required = false, example = "券已使用数")
    private Integer couponUseNumber;

    /**
     * 只读.
     * 券未使用数. coupon_unused_number
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "券未使用数", name = "couponUnusedNumber", required = false, example = "券未使用数")
    private Integer couponUnusedNumber;

    /**
     * 只读.
     * 券已过期数. coupon_past_due_number
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "券已过期数", name = "couponPastDueNumber", required = false, example = "券已过期数")
    private Integer couponPastDueNumber;

    /**
     * 只读.
     * 是否参与活动1：是,2：否. activity
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "是否参与活动1：是,2：否", name = "activity", required = false, example = "是否参与活动1：是,2：否")
    private Boolean activity;

    /**
     * 只读.
     * 是否参与任务1：是,2：否. task
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "是否参与任务1：是,2：否", name = "task", required = false, example = "是否参与任务1：是,2：否")
    private Boolean task;

    /**
     * 只读.
     * 首次购买时间. first_buy_time
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "首次购买时间", name = "firstBuyTime", required = false, example = "首次购买时间")
    private Date firstBuyTime;

    /**
     * 只读.
     * 最后购买时间. last_buy_time
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "最后购买时间", name = "lastBuyTime", required = false, example = "最后购买时间")
    private Date lastBuyTime;

    /**
     * 只读.
     * 数据传输时间. update_time
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "数据传输时间", name = "updateTime", required = false, example = "数据传输时间")
    private Date updateTime;

    /**
     * 只读.
     * 消息md5加密. md5_value
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "消息md5加密", name = "md5Value", required = false, example = "消息md5加密")
    private String md5Value;

    /**
     * 只读.
     * 线下会员id. vip_id
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "线下会员id", name = "vipId", required = false, example = "线下会员id")
    private String vipId;

    /**
     * 只读.
     * 线下品牌code. brand_code
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "线下品牌code", name = "brandCode", required = false, example = "线下品牌code")
    private String brandCode;

    /**
     * 只读.
     * 活跃店铺线下code. active_store_offline_code
     *
     * @mbg.generated 2018-10-17 10:55:24
     */
    @ApiModelProperty(value = "活跃店铺线下code", name = "activeStoreOfflineCode", required = false, example = "活跃店铺线下code")
    private String activeStoreOfflineCode;
}
